package com.quantgroup.asset.distribution.attribute;

import java.lang.reflect.Field;

import com.quantgroup.asset.distribution.config.annotation.Attribute;
import com.quantgroup.asset.distribution.model.form.AssetForm;
import com.quantgroup.asset.distribution.service.jpa.entity.Asset;
import com.quantgroup.asset.distribution.util.UUIDUtil;

/**
 * 资产测试
 * @author liwenbin
 *
 */
public class AssetTest {
	
	public static void main(String[] args) throws IllegalArgumentException, IllegalAccessException {
		AssetForm assetForm = new AssetForm();
		assetForm.setCode("0");
		assetForm.setMsg("success");
		assetForm.setUuid("561e6790-9080-41bc-8c1d-8e2524867b27");
		assetForm.setBizChannel("159843");
		assetForm.setBizNo("SP493016826165714789463533");
		assetForm.setBizType("0");
		assetForm.setAuditResult("false");
		assetForm.setDeadLine("deadLine");
		assetForm.setCallbackUrl("callbackUrl");
		assetForm.setAssetNo(UUIDUtil.getAssetNo());
		
		Asset asset = assetForm.transToAsset();
		Class<?> clazz = asset.getClass();
		Field[] flelds = clazz.getDeclaredFields();
		for (Field field : flelds) {
			if (field.isAnnotationPresent(Attribute.class) && field.getAnnotation(Attribute.class).value()) {
				field.setAccessible(true);
				String name = field.getName();
				System.out.println(field.getName() + ":" + field.get(asset));
				name = checkName(name);
				System.out.println(name + ":" + field.get(asset));
			}
		}
	}
	
	
	public static String checkName(String name) {
		StringBuilder sb = new StringBuilder();
		char[] chs = name.toCharArray();
		for (int i = 0, len = chs.length; i < len; ++i) {
			if (Character.isUpperCase(chs[i])) {
				sb.append("_" + Character.toLowerCase(chs[i]));
			} else {
				sb.append(chs[i]);
			}
		}
		return sb.toString();
	}
}
