package com.quantgroup.asset.distribution.service.notify.impl;

import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.quantgroup.asset.distribution.model.form.AssetForm;
import com.quantgroup.asset.distribution.service.alarm.IAlarmService;
import com.quantgroup.asset.distribution.service.distribute.IDistributeFailLogService;
import com.quantgroup.asset.distribution.service.httpclient.IHttpService;
import com.quantgroup.asset.distribution.service.notify.INotifyService;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@Service
public class NotifyServiceImpl implements INotifyService{
	
	@Value("${isDebug}")
    private Boolean isDebug;
	
	@Autowired
	private IHttpService httpService;
	@Autowired
	private IDistributeFailLogService distributeFailLogService;
	@Autowired
	private IAlarmService alarmService;
	
	@Async
	@Override
	public void notifyFundServer(AssetForm assetForm) {
		try {
			if (isDebug) { return; }
			log.info("通知资金系统结果开始, uuid : {}, bizNo : {}, assetNo : {}, callbackUrl : {}, assetForm : {}", assetForm.getUuid(), assetForm.getBizNo(), assetForm.getAssetNo(), assetForm.getCallbackUrl(), JSON.toJSONString(assetForm));
			if (StringUtils.isEmpty(assetForm.getCallbackUrl())) { 
				log.info("通知资金系统结果失败，callbackUrl为空, uuid : {}, bizNo : {}, assetNo : {}, assetForm : {}", assetForm.getUuid(), assetForm.getBizNo(), assetForm.getAssetNo(), JSON.toJSONString(assetForm));
				return;
			}
			Map<String, String> response = httpService.postHasResponse(assetForm.getCallbackUrl(), assetForm.transToNotifyMap());
			log.info("通知资金系统结果结束, uuid : {}, bizNo : {}, assetNo : {}, callbackUrl : {}, assetForm : {}, response : {}", assetForm.getUuid(), assetForm.getBizNo(), assetForm.getAssetNo(), assetForm.getCallbackUrl(), JSON.toJSONString(assetForm), JSON.toJSONString(response));
			if(response==null || response.size()==0 || !"200".equals(response.get("statusCode")) || "error".equals(response.get("response"))) {
				distributeFailLogService.saveDistributeFailLog(assetForm, "通知资金系统失败.");
				alarmService.dingtalkAlarm("Warn", "资产入库分发通知资金系统失败", "bizChannel : " + assetForm.getBizChannel()
					+ " , bizType : " + assetForm.getBizType() + " , bizNo : " + assetForm.getBizNo()
					+ " , assetNo : " + assetForm.getAssetNo() + " , uuid : " + assetForm.getUuid());
			}
		} catch (Exception e) {
			log.info("通知资金系统结果异常, uuid : {}, bizNo : {}, assetNo : {}, callbackUrl : {}, assetForm : {}", assetForm.getUuid(), assetForm.getBizNo(), assetForm.getAssetNo(), assetForm.getCallbackUrl(), JSON.toJSONString(assetForm), e);
		}
	}
}
