package com.quantgroup.asset.distribution.service.jpa.repository;

import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;

import com.quantgroup.asset.distribution.service.jpa.entity.FundModuleChannelFundConfig;

/**
 * 渠道资方配置表Repository
 * @author liwenbin
 *
 */
public interface IFundModuleChannelFundConfigRepository extends JpaRepository<FundModuleChannelFundConfig, Long>, JpaSpecificationExecutor<FundModuleChannelFundConfig>{
	
	/**
	 * 根据渠道号查询渠道资方配置
	 * @param bizChannel
	 * @return
	 */
	public List<FundModuleChannelFundConfig> findByBizChannelAndEnableIsTrue(String bizChannel);
	
	/**
	 * 根据id查询渠道资方配置
	 * @param id
	 * @return
	 */
	public FundModuleChannelFundConfig findByIdAndEnableIsTrue(Long id);
	
	/**
	 * 注意，这个是给渠道资方配置审批用的，慎用，这个不关注enable状态
	 * @param id
	 * @return
	 */
	public FundModuleChannelFundConfig findById(Long id);
}
