package com.quantgroup.asset.distribution.service.niwodai.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.quantgroup.asset.distribution.constant.RedisKeyConstants;
import com.quantgroup.asset.distribution.exception.QGException;
import com.quantgroup.asset.distribution.service.httpclient.IHttpService;
import com.quantgroup.asset.distribution.service.niwodai.INiwodaiService;
import com.quantgroup.asset.distribution.service.niwodai.vo.*;
import com.quantgroup.asset.distribution.service.redis.IRedisService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Base64;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import static com.quantgroup.asset.distribution.exception.QGExceptionType.COMMON_THIRD_PARTY_TIMEOUT;


@Slf4j
@Service
public class NiwodaiServiceImpl implements INiwodaiService {
    @Value("${niwodai.url.authDomain}")
    private String domain;
    @Value("${niwodai.url.dataDomain}")
    private String domain2;
    @Value("${niwodai.url.dataCheck}")
    private String dataImportCheckUrl;
    @Value("${niwodai.url.auth}")
    private String authUrl;
    @Value("${niwodai.url.incoming}")
    private String incomingUrl;
    @Value("${niwodai.client.id}")
    private String clientId;
    @Value("${niwodai.client.secret}")
    private String clientSecret;

    @Autowired
    IRedisService<String> iRedisService;
    @Autowired
    IHttpService iHttpService;

    @Override
    public NiwodaiDataImportCheckResponseVO dataImportCheck(NiwodaiDataImportCheckRequestVO requestVO) {
        String token = getToken();
        if (StringUtils.isEmpty(token)) {
            log.error("你我贷准入检查时获取token失败,requestVO : {}", JSON.toJSONString(requestVO));
            throw new QGException("你我贷准入检查时获取token失败", COMMON_THIRD_PARTY_TIMEOUT);
        }
        String result = iHttpService.postNiwodaiJson(domain2 + dataImportCheckUrl, commonHeader(token), JSON.toJSONString(requestVO), true);
        if (StringUtils.isNotEmpty(result)) {
            return JSON.parseObject(result, NiwodaiDataImportCheckResponseVO.class);
        }
        return null;
    }

    @Override
    public NiwodaiIncomingResponseVO incoming(NiwodaiIncomingRequestVO requestVO) {
        String token = getToken();
        if (StringUtils.isEmpty(token)) {
            log.error("你我贷进件时获取token失败,requestVO : {}", JSON.toJSONString(requestVO));
            throw new QGException("你我贷进件时获取token失败", COMMON_THIRD_PARTY_TIMEOUT);
        }
        String result = iHttpService.postNiwodaiJson(domain2 + incomingUrl, commonHeader(token), JSON.toJSONString(requestVO),true);
        if (StringUtils.isNotEmpty(result)) {
            return JSON.parseObject(result, NiwodaiIncomingResponseVO.class);
        }
        return null;
    }

    public String getToken() {
        String token = iRedisService.getString(RedisKeyConstants.NI_WO_DAI_TOKEN_KEY);
        if (StringUtils.isBlank(token)) {
            NiwodaiAccessTokenResponseVO vo = acquireAccessToken();
            if (vo != null){
                token = vo.getAccessToken();
                iRedisService.setStringEx(RedisKeyConstants.NI_WO_DAI_TOKEN_KEY,token,8, TimeUnit.MINUTES);
            }else {
                return null;
            }
        }
        return token;
    }

    public NiwodaiAccessTokenResponseVO acquireAccessToken() {
        Map<String, String> header = Maps.newHashMap();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        header.put("Authorization", "Basic " + Base64.getEncoder().encodeToString((clientId + ":" + clientSecret).getBytes()));
        Map<String, String> parameters = Maps.newHashMap();
        parameters.put("grant_type", "client_credentials");
        String result = null;
        try {
            result = iHttpService.postNiwodai(domain + authUrl, header, parameters, true);
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (StringUtils.isNotEmpty(result)) {
            return JSON.parseObject(result, NiwodaiAccessTokenResponseVO.class);
        }
        return null;
    }

    private static Map<String, String> commonHeader(String token) {
        Map<String, String> header = Maps.newHashMap();
        header.put("Authorization", " bearer " + token);
        header.put("Content-Type", "application/json");
        return header;
    }

}
