package com.quantgroup.asset.distribution.service.funding.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Stopwatch;
import com.quantgroup.asset.distribution.config.annotation.HandleException;
import com.quantgroup.asset.distribution.constant.FundModuleConstants;
import com.quantgroup.asset.distribution.enums.response.FundModuleResponse;
import com.quantgroup.asset.distribution.exception.QGExceptionType;
import com.quantgroup.asset.distribution.exception.QGPreconditions;
import com.quantgroup.asset.distribution.model.entity.fund.FundInfo;
import com.quantgroup.asset.distribution.model.response.GlobalResponse;
import com.quantgroup.asset.distribution.service.funding.IFundModuleChannelFundConfigService;
import com.quantgroup.asset.distribution.service.funding.IFundModuleLimitTypeService;
import com.quantgroup.asset.distribution.service.funding.IFundModuleService;
import com.quantgroup.asset.distribution.service.httpclient.IHttpService;
import com.quantgroup.asset.distribution.service.jpa.entity.FundModuleLimitTypeConfig;

import lombok.extern.slf4j.Slf4j;

/**
 * 资方模块Service
 * @author liwenbin
 *
 */
@Service
@Slf4j
public class FundModuleServiceImpl implements IFundModuleService{
	
	@Autowired
	private IHttpService httpService;
	@Autowired
	private IFundModuleLimitTypeService fundModuleLimitTypeService;
	@Autowired
	private IFundModuleChannelFundConfigService fundModuleChannelFundConfigService;
	@Value("${clotho.url}")  
	private String clothoURL;

	@HandleException
	@Override
	public GlobalResponse getAllFundsInfo() {
		Stopwatch stopwatch = Stopwatch.createStarted();
		String text = httpService.get(clothoURL + "/ex/funding/corp/all.json");
		log.info("拉取xyqb所有资方信息完成, 耗时 : {}, 结果 : {}", stopwatch.stop().elapsed(TimeUnit.MILLISECONDS), text);
		QGPreconditions.checkArgument(StringUtils.isNotEmpty(text), QGExceptionType.GET_ALL_FUNDS_INFO_ERROR, text);
		JSONObject data = JSONObject.parseObject(text);
		QGPreconditions.checkArgument(data != null && "0000".equals(data.getString("code")), QGExceptionType.GET_ALL_FUNDS_INFO_ERROR, text);
		// 将xyqb返回的结果转化成返回结果
		List<FundInfo> fundInfoList = new ArrayList<>();
		JSONArray fundsArray = data.getJSONArray("data");
		for (int i = 0, len = fundsArray.size(); i < len; ++i) {
			FundInfo fundInfo = new FundInfo();
			JSONObject fundInfoJSON = fundsArray.getJSONObject(i);
			fundInfo.setFundId(fundInfoJSON.getLong("id"));
			fundInfo.setFundName(fundInfoJSON.getString("name"));
			fundInfo.setStrategyName(fundInfoJSON.getString("strategyName"));
			fundInfoList.add(fundInfo);
		}
		return GlobalResponse.create(FundModuleResponse.SUCCESS, fundInfoList);
	}

	@HandleException
	@Override
	public GlobalResponse getAllLimitType() {
		List<FundModuleLimitTypeConfig> configList = fundModuleLimitTypeService.getAllLimitType();
		return GlobalResponse.create(FundModuleResponse.SUCCESS, configList);
	}

	@HandleException
	@Override
	public GlobalResponse saveChannelFundConfig(Integer type, Long id, String bizChannel, String funds, String remarks) {
		if (type == FundModuleConstants.CHANNEL_FUNDS_OPERAOTR_TYPE_ADD) {
			return fundModuleChannelFundConfigService.addChannelFundConfig(bizChannel, funds, remarks);
		} else if (type == FundModuleConstants.CHANNEL_FUNDS_OPERATOR_TYPE_UPDATE) {
			return fundModuleChannelFundConfigService.updateChannelFundConfig(id, bizChannel, funds, remarks);
		} else {
			return GlobalResponse.create(FundModuleResponse.SUCCESS);
		}
	}

	@HandleException
	@Override
	public GlobalResponse getChannelFundConfigs(String bizChannel, Long fundId, Integer pageNum, Integer pageSize) {
		Map<String, Object> result = fundModuleChannelFundConfigService.getChannelFundConfigsByChannelOrFundId(bizChannel, fundId, pageNum, pageSize);
		if (result.size() == 0) {
			return GlobalResponse.create(FundModuleResponse.HAS_NO_DATA);
		}
		return GlobalResponse.success(result);
	}
}
