package com.quantgroup.asset.distribution.service.jpa.repository;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;

import com.quantgroup.asset.distribution.service.jpa.entity.ApprovalLog;
import org.springframework.data.jpa.repository.Query;

import java.math.BigInteger;
import java.util.List;

public interface IApprovalLogRepository  extends JpaRepository<ApprovalLog, Long>, JpaSpecificationExecutor<ApprovalLog>{
	
	public ApprovalLog findByIdAndEnableIsTrue(Long id);

	public ApprovalLog findByAuditTypeAndAuditTargetAndTargetNameAndAuditStatusAndEnableIsTrue(Integer auditType,
																							   Integer auditTarget,
																							   String targetName,
																							   Integer auditStatus);

	@Query(value = "select audit_config_id from approval_log where audit_type = 1 and target_name = ?1 and (audit_status = 0 or audit_status = 1) order by audit_status asc,updated_at desc", nativeQuery = true)
	List<BigInteger> findAuditConfigIds(String channel);

	@Query(value = "select audit_config_id from approval_log where audit_type = 1 and (audit_status = 0 or audit_status = 1) order by audit_status asc,updated_at desc",nativeQuery = true)
	List<BigInteger> findAuditConfigIds();
}
