package com.quantgroup.asset.distribution.authority;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import com.quantgroup.asset.distribution.AssetDistributionBootstrap;
import com.quantgroup.asset.distribution.exception.QGExceptionType;
import com.quantgroup.asset.distribution.exception.QGPreconditions;
import com.quantgroup.asset.distribution.service.jpa.entity.AuthorityConfig;
import com.quantgroup.asset.distribution.service.jpa.repository.IAuthorityRepository;
import com.quantgroup.asset.distribution.util.calc.Expression;

/**
 * 权限配置测试类
 * @author liwenbin
 *
 */
@RunWith(SpringRunner.class)
@SpringBootTest(classes = AssetDistributionBootstrap.class)
public class AuthorityTest {
	
	@Autowired
	private IAuthorityRepository authorityRepository;
	
	@Test
	public void testAuthorityRepository() {
		AuthorityConfig config = authorityRepository.findByAuthKeyAndAuthPassAndEnableIsTrue("lz_mo_fang", "123456");
		System.out.println(config);
	}
	
	@Test
	public void testRepository() {
	}
	
	
	
	public static void main(String[] args) {
//		com.quantgroup.asset.distribution.util.calc.Expression expression = new com.quantgroup.asset.distribution.util.calc.Expression("filter_fraud_point_v5==false");
//		BigDecimal result = expression.with("filter_fraud_point_v5", "true").eval();
//		System.out.println(result.compareTo(BigDecimal.ZERO) == 1);
//		System.out.println(expression.with("filter_fraud_point_v5", "0.04").with("2022872_result", "32").eval());
//		Expression expression = new Expression("filter_fraud_point_v5<0.4");
//		System.out.println(expression.with("filter_fraud_point_v5", "0.03").eval());
		String expression = "filter_fraud_point_v5>0.06";
		Map<String, Object> data = new HashMap<String, Object>();
		data.put("filter_fraud_point_v5", (Object)0.07);
		data.put("v5", (Object)666);
		data.put("liwenbin", (Object)7);
		Expression ex = new Expression(expression);
		for (Map.Entry<String, Object> entry : data.entrySet()) {
			ex.with(entry.getKey(), String.valueOf(entry.getValue()));
		}
		
		System.out.println(ex.eval());
	}
}
