/*
 * Copyright 2014-present Miyou tech inc. All Rights Reserved.
 */

package com.quantgroup.asset.distribution.exception;

import lombok.extern.slf4j.Slf4j;

/**
 * 系统使用Exception来进行Error Code处理。如果LogType为Error，
 * 代表这种Error不应该返回给客户端，应该统一打印出服务器端错误；
 * 如果是WARNING的话，就将对应的Exception Text返回给客户端。
 */
@Slf4j
public enum QGExceptionType {
    COMMON_SERVER_ERROR(1001, "系统异常，请稍后再试"),
    COMMON_ILLEGAL_STATE(1002, "断言错误"),
    COMMON_ILLEGAL_PARAM_TOAST(1003, "参数异常", "%s"),
    COMMON_AUTH_ERROR(1004, "系统异常，请稍后再试"),
    COMMON_ILLEGAL_PARAM(1010, "参数异常"),
    COMMON_THIRD_PARTY_TIMEOUT(1011, "第三方服务超时"),
    COMMON_ENUM_NOT_EXIST(1012,"枚举不存在"),
    COMMON_STRING_PARAM_IS_ALL_NULL(1013, "参数不能为空", "%s不能为空"),
    
    ASSET_IN_CODE_ERROR(2001, "资产入库code异常! uuid : %s, bizNo : %s, code : %s"),
	GET_DEC_ATTRIBUTE_VALUE_ERROR(2002, "获取决策资产属性值异常, uuid : %s, keys : %s"),
	ASSET_ATTRIBUTE_IS_EMPTY(2003, "%s资产属性值为空"),
	TRANSFORM_ASSET_ATTRIBUTE_ERROR(2004, "资产属性值转换成Map异常!"),
	
	DISTRIBUTE_RULE_CONFIG_PRIORITY_IS_NOT_UNIQUE(2021, "资产分发规则优先级不唯一"),
	RULE_CALC_ERROR(2022, "规则计算出现错误， expression : %s"),
	RULE_CALC_UNKNOW_ERROR(2023, "规则计算出现未知异常, expression : %s"),
	RULE_CALC_UNKNOW_RESULT(2024, "规则判断出现未知结果，请联系管理人员, expression : %s"),
	UNKNOW_RULE_TYPE(2025, "未知的规则类型, %s"),
	NO_DISTRIBUTE_NODE(2026, "未找到分发节点, uuid : %s, assetNo %s, records : %s"),
    RULE_EXPRESSION_IS_EMPTY(2027, "规则表达式未空"),
    RULE_IS_NOT_JSON(2028, "规则不是json,解析失败"),
    RULE_UNION_OPERATOR_NOT_EXIST(2029, "联合规则符不存在"),
    DATA_NOT_EXIST_FOR_RULE(2030, "规则数据不存在,key:%s, operator:%s, value:%s"),
    RULE_OPERATOR_IS_EMPTY(2031, "规则符为空"),
    RULE_DATA_IS_EMPTY(2032, "规则数据为空,key:%s, operator:%s, value:%s"),
    DATA_COMPARE_ERROR(2033, "数据比较出现错误"),
    RULE_OPERATOR_NOT_EXIST(2034, "规则符不存在"),

	
	NOTIFY_FUND_SERVER_ERROR(2041, "通知资金系统失败, uuid : %s, bizNo : %s, assetNo : %s"),
	NOT_FOUND_FUND_SERVER_RESULT_BIZNO(2042, "未找到资金结果通知订单, bizNo : %s, status : %s"),
	NOTIFY_BUSINESS_FLOW_ERROR(2042, "通知业务流系统订单终态失败, bizNo : %s, status : %s"),
	
	// 资方模块错误信息
	GET_ALL_FUNDS_INFO_ERROR(3001, "拉取所有资方信息失败, res : %s"),
	NO_FUND_INFO_BEEN_HIT(3002, "未命中任何资方, bizChannel : %s, amount : %s, term : %s"),
	FUND_PRIORITY_IS_ERROR(3003, "资方优先级不符合要求, bizChannel : %s, amount : %s, term : %s"),
	NOT_FOUNT_CHANNEL_FUNDS_INFO(3004, "未找到渠道资方配置, 请检查; bizChannel : %s"),
	CHANNEL_FUND_CONFIG_GREATER_THAN_TOW(3005, "渠道资方有效配置大于2条，请检查; bizChannel : % s"),
	HIT_FUND_BUT_AMOUNT_OR_TERM_IS_EMPTY(3006, "命中资方但额度或期数为空, 请检查!");
	
	
	

    public int code;
    public String text;
    public String frontEndToastTemplate;

    QGExceptionType(int code, String text) {
        this.code = code;
        this.text = text;
        this.frontEndToastTemplate = text;
    }

    QGExceptionType(int code, String text, String frontEndToastTemplate) {
        this.code = code;
        this.text = text;
        this.frontEndToastTemplate = frontEndToastTemplate;
    }

    public static QGExceptionType fromCode(int code) {
        for (QGExceptionType exceptionType : QGExceptionType.values()) {
            if (exceptionType.code == code) {
                return exceptionType;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return "error_code: " + code + ", text: " + text + ", frontEndToastTemplate: " + frontEndToastTemplate;
    }
}
