package com.quantgroup.asset.distribution.service.funding;

import com.quantgroup.asset.distribution.model.form.AssetForm;
import com.quantgroup.asset.distribution.service.jpa.entity.Asset;

import java.util.Map;

/**
 * @author : Hyuk
 * @description : IAidFundAssetService
 * @date : 2020/3/27 5:07 下午
 */
public interface IAidFundAssetService {

    /**
     * 准入审核，预审
     * @param assetForm
     * @return
     */
    public boolean preAudit(AssetForm assetForm, String fundId);

    /**
     * 进件审核
     * @param assetForm
     * @param data
     * @param userLoanType
     * @return true:进件成功 false:进件失败
     */
    public boolean audit(AssetForm assetForm, Map<String, Object> data, Asset asset, String fundId);
}
