package com.quantgroup.asset.distribution.service.funding.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import com.quantgroup.asset.distribution.enums.response.FundModuleResponse;
import com.quantgroup.asset.distribution.model.response.GlobalResponse;
import com.quantgroup.asset.distribution.service.funding.IFundModuleChannelFundConfigService;
import com.quantgroup.asset.distribution.service.jpa.entity.FundModuleChannelFundConfig;
import com.quantgroup.asset.distribution.service.jpa.repository.IFundModuleChannelFundConfigRepository;
import com.quantgroup.asset.distribution.util.fund.module.ChannelFundConfigUtil;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@Service
public class FundModuleChannelFundConfigServiceImpl implements IFundModuleChannelFundConfigService{
	
	@Autowired
	private IFundModuleChannelFundConfigRepository fundModuleChannelFundConfigRepository;

	/**
	 * 分页使用
	 */
	@Override
	public Map<String, Object> getChannelFundConfigsByChannelOrFundId(String bizChannel, Long fundId,
			Integer pageNum, Integer pageSize) {
		// 分页条件
		Pageable pageable = new PageRequest(pageNum < 0 ? 0 : pageNum, pageSize);
		Specification<FundModuleChannelFundConfig> specification = new Specification<FundModuleChannelFundConfig>() {
			@Override
			public Predicate toPredicate(Root<FundModuleChannelFundConfig> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
				List<Predicate> predicates = new ArrayList<>();
				predicates.add(cb.equal(root.get("enable"), true));
	            if(StringUtils.isNotEmpty(bizChannel)){
	                predicates.add(cb.equal(root.get("bizChannel"), bizChannel));
	            }
	            if(fundId != null){
	            	predicates.add(cb.like(root.get("fundIds"), "%" + fundId + "%"));
	            }
	            query.where(predicates.toArray(new Predicate[predicates.size()]));
	            return query.getRestriction();
			}
		};
		Page<FundModuleChannelFundConfig> channelFundConfigs = fundModuleChannelFundConfigRepository.findAll(specification, pageable);
		Map<String, Object> result = new HashMap<>();
		result.put("total", channelFundConfigs.getTotalElements());
		result.put("pages", channelFundConfigs.getTotalPages());
		result.put("pageSize", channelFundConfigs.getSize());
		result.put("pageNum", channelFundConfigs.getNumber());
		result.put("list", channelFundConfigs.getContent());
		return result;
	}

	@Override
	public GlobalResponse addChannelFundConfig(String bizChannel, String funds, String remarks) {
		// 新增配置, 根据渠道查询如果库里已存在，返回异常;测试一下渠道号存在2条配置去find正常否
		FundModuleChannelFundConfig fundModuleChannelFundConfig = fundModuleChannelFundConfigRepository.findByBizChannelAndEnableIsTrue(bizChannel);
		if (fundModuleChannelFundConfig != null) {
			log.info("资方模块, 渠道 : {}资方配置已存在, 添加失败!", bizChannel);
			return GlobalResponse.create(FundModuleResponse.CHANNEL_FUND_CONFIG_IS_EXIST);
		}
		fundModuleChannelFundConfig = new FundModuleChannelFundConfig();
		fundModuleChannelFundConfig.setBizChannel(bizChannel);
		fundModuleChannelFundConfig.setFunds(funds);
		fundModuleChannelFundConfig.setRemarks(remarks);
		fundModuleChannelFundConfig.setFundIds(ChannelFundConfigUtil.getAllFundIds(funds));
		fundModuleChannelFundConfig.setEnable(true);
		fundModuleChannelFundConfigRepository.save(fundModuleChannelFundConfig);
		return GlobalResponse.create(FundModuleResponse.SUCCESS);
	}

	@Override
	public GlobalResponse updateChannelFundConfig(Long id, String bizChannel, String funds, String remarks) {
		// 更改配置, 根据id查询如果库里不存在，返回异常
		FundModuleChannelFundConfig fundModuleChannelFundConfig = fundModuleChannelFundConfigRepository.findByIdAndEnableIsTrue(id);
		if (fundModuleChannelFundConfig == null) {
			log.info("资方模块, 渠道 : {}, 配置id : {}, 资方配置不存在, 修改失败!", bizChannel, id);
			return GlobalResponse.create(FundModuleResponse.CHANNEL_FUND_CONFIG_NOT_EXIST);
		}
		fundModuleChannelFundConfig.setBizChannel(bizChannel);
		fundModuleChannelFundConfig.setFunds(funds);
		fundModuleChannelFundConfig.setRemarks(remarks);
		fundModuleChannelFundConfig.setFundIds(ChannelFundConfigUtil.getAllFundIds(funds));
		fundModuleChannelFundConfig.setEnable(true);
		fundModuleChannelFundConfigRepository.save(fundModuleChannelFundConfig);
		return GlobalResponse.create(FundModuleResponse.SUCCESS);
	}

	@Override
	public FundModuleChannelFundConfig findByBizChannel(String bizChannel) {
		return fundModuleChannelFundConfigRepository.findByBizChannelAndEnableIsTrue(bizChannel);
	}
}
