package com.quantgroup.asset.distribution.service.jpa.repository;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

import com.quantgroup.asset.distribution.service.jpa.entity.FundModuleChannelFundConfig;

/**
 * 渠道资方配置表Repository
 * @author liwenbin
 *
 */
public interface IFundModuleChannelFundConfigRepository extends JpaRepository<FundModuleChannelFundConfig, Long>, JpaSpecificationExecutor<FundModuleChannelFundConfig>{
	
	/**
	 * 根据渠道号查询渠道资方配置
	 * @param bizChannel
	 * @return
	 */
	public FundModuleChannelFundConfig findByBizChannelAndEnableIsTrue(String bizChannel);
	
	/**
	 * 根据id查询渠道资方配置
	 * @param id
	 * @return
	 */
	public FundModuleChannelFundConfig findByIdAndEnableIsTrue(Long id);
	
	/**
	 * 
	 * @param id
	 * @return
	 */
	public FundModuleChannelFundConfig findById(Long id);
}
