package com.quantgroup.asset.distribution.service.distribute.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import com.quantgroup.asset.distribution.service.distribute.IAssetDistributeRuleConfigService;
import com.quantgroup.asset.distribution.service.jpa.entity.AssetDistributeRuleConfig;
import com.quantgroup.asset.distribution.service.jpa.repository.IAssetDistributeRuleConfigRepository;

/**
 * 资产分发规则配置Service
 * @author liwenbin
 *
 */
@Service
public class AssetDistributeRuleConfigServiceImpl implements IAssetDistributeRuleConfigService{
	
	@Autowired
	private IAssetDistributeRuleConfigRepository assetDistributeRuleConfigRepository;

	@Override
	@Cacheable(value="cacheManager",key="'ASSET_2028D_ALL_RULE_CONFIG'")
	public List<AssetDistributeRuleConfig> getAllRuleConfigOrderByPriorityAsc() {
		return assetDistributeRuleConfigRepository.findByEnableIsTrueOrderByAssetDistributeRulePriorityAsc();
	}
	
	@Override
	@CacheEvict(value = "cacheManager", key = "'ASSET_2028D_ALL_RULE_CONFIG'")
	public void clearRuleConfigCache() {
	}

}
