package com.quantgroup.asset.distribution.distribute;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.quantgroup.asset.distribution.AssetDistributionBootstrap;
import com.quantgroup.asset.distribution.constant.StatusConstants;
import com.quantgroup.asset.distribution.enums.funding.FundingResult;
import com.quantgroup.asset.distribution.model.entity.DistributeRecord;
import com.quantgroup.asset.distribution.service.distribute.IAssetDistributeRecordService;
import com.quantgroup.asset.distribution.service.distribute.IAssetDistributeService;
import com.quantgroup.asset.distribution.service.httpclient.IHttpService;
import com.quantgroup.asset.distribution.service.jpa.entity.AssetDistributeRecord;
import com.quantgroup.asset.distribution.service.jpa.repository.IAssetDistributeRecordRepository;

@SpringBootTest(classes = AssetDistributionBootstrap.class)
@RunWith(SpringRunner.class)
public class DistributeTest {
	
	@Autowired
	private IAssetDistributeRecordService assetDistributeRecordService;
	@Autowired
	private IAssetDistributeRecordRepository assetDistributeRecordRepository;
	@Autowired
	private IHttpService httpService;
	@Autowired
    private IAssetDistributeService distributeService;
	
	@Test
	public void testEn() {
//		List<AssetDistributeRecord> list = assetDistributeRecordRepository.findByAssetNoAndEnableIsTrue("ASET0faf33c1d2ca47cfb9828d7d79396264");
//		System.out.println(list);
//		System.out.println(list.size());
		AssetDistributeRecord asset = assetDistributeRecordRepository.findByBizNoOrderByCreatedAtDescLimitOne("SP493016826165714789463533");
		System.out.println(asset);
	}
	
	@Test
	public void test() {
		List<AssetDistributeRecord> assetDistributeRecords = assetDistributeRecordService.getDistributeRecord("ASET0645dd8bdbe5458dacccad57ab22fbaf");
		List<Integer> list = new ArrayList<>();
		for (AssetDistributeRecord assetDistributeRecord : assetDistributeRecords) {
			JSONArray array = JSON.parseObject(assetDistributeRecord.getAssetDistributeTravel()).getJSONArray("records");
			for (int i = 0, len = array.size(); i < len; ++i) {
				JSONObject record = array.getJSONObject(i);
				list.add(record.getInteger("type"));
			}
		}
		System.out.println(list);
	}
	
	@Test
	public void testHttp() {
		String result = httpService.post("http://localhost:9050" + "/feature/get", new HashMap<String, String>(){{
			put("uuid", "123213");
			put("bizChannel", "123213");
			put("bizNo", "1232131");
			put("bizType", "123213131");
			put("keys", "12321321");
			put("method", "0");
		}});
	}

	@Test
	public void testUpdateRecordStatus() {
//		AssetDistributeRecord record = assetDistributeRecordRepository.findByBizNoOrderByCreatedAtDescLimitOne("1231231231231");
//		record.setAssetDistributeStatus(StatusConstants.SUCCESS);
//		assetDistributeRecordRepository.save(record);
		distributeService.receiveFundingResult("SP499997499085250626417877", FundingResult.FUAD_ASSIGN_SUCC);
	}
	
	public static void main(String[] args) {
		String ms = "{\"data\":{\"applyNo\":\"SP518202446325688840197868\",\"loanId\":0,\"loanProgress\":\"FILTERING_DECLINED\",\"termNo\":-1},\"extraData\":\"{\\\"nextOperateDate\\\":\\\"1569081600000\\\",\\\"orderNo\\\":\\\"SP518202446325688840197868\\\",\\\"refuseReason\\\":\\\"审核拒绝\\\",\\\"rejectTime\\\":1566556270084}\",\"noticeType\":\"REJECT\"}";
//		JSONObject jo = JSONObject.parseObject(ms);
//        String noticeType = jo.getString("noticeType");
//        String applyNo = jo.getJSONObject("data").getString("applyNo");
//        if(FundingResult.REJECT.getCode().equals(noticeType)
//                || FundingResult.HANG_UP.getCode().equals(noticeType)
//                || FundingResult.CANCEL_LOAN.getCode().equals(noticeType)
//                || FundingResult.FUAD_ASSIGN_SUCC.getCode().equals(noticeType)){
//        	String s = "REJECT";
//            System.out.println(FundingResult.fromCode(s));
//            System.out.println(FundingResult.fromCode(noticeType));
//        }
		
		String s = "{\"key\" : \"115\"}";
		
		JSONObject js = JSON.parseObject(s);
		String s3 = js.getString("key");
		String s1 = "115";
		String s2 = "115";
		System.out.println(s1 == s2);
		System.out.println(s1 == s3);
	}
	
}
