package com.quantgroup.asset.distribution.util.fund.module;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import lombok.extern.slf4j.Slf4j;

/**
 * 渠道资方配置信息工具类
 * @author liwenbin
 *
 */
@Slf4j
public class ChannelFundConfigUtil {
	
	/**
	 * 检测渠道配置funds信息是否正常
	 * @return
	 */
	public static boolean checkFunds(String channelFundConfigInfo) {
		try {
			if (StringUtils.isEmpty(channelFundConfigInfo)) {
				return false;
			}
			JSONArray array = JSONArray.parseArray(channelFundConfigInfo);
			for (int i = 0, len = array.size(); i < len; i++) {
				JSONObject data = array.getJSONObject(i);
				if (data.getLong("fundId") == null) {
					return false;
				}
				if (StringUtils.isEmpty("fundName")) {
					return false;
				}
				if (StringUtils.isEmpty("rate")) {
					return false;
				}
				if (StringUtils.isEmpty("feeType")) {
					return false;
				}
				if (StringUtils.isEmpty("rateType")) {
					return false;
				}
				if (StringUtils.isEmpty("priority")) {
					return false;
				}
			}
			return true;
		} catch (Exception e) {
			log.error("检查渠道资方配置信息出现异常!", e);
			return false;
		}
	}
	
	/**
	 * 根据资方配置信息获取所有资方
	 * @param funds
	 * @return
	 */
	public static String getAllFundIds(String funds) {
		Set<String> fundIdSet = new LinkedHashSet<>();
		JSONArray array = JSONArray.parseArray(funds);
		for (int i = 0, len = array.size(); i < len; i++) {
			JSONObject data = array.getJSONObject(i);
			fundIdSet.add(data.getString("fundId"));
		}
		return StringUtils.join(fundIdSet, ",");
	}
}
