package com.quantgroup.asset.distribution.service.notify.impl;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.quantgroup.asset.distribution.exception.QGException;
import com.quantgroup.asset.distribution.exception.QGExceptionType;
import com.quantgroup.asset.distribution.model.form.AssetForm;
import com.quantgroup.asset.distribution.service.alarm.IAlarmService;
import com.quantgroup.asset.distribution.service.httpclient.IHttpService;
import com.quantgroup.asset.distribution.service.notify.INotifyService;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@Service
public class NotifyServiceImpl implements INotifyService{
	
	@Value("${isDebug}")
    private Boolean isDebug;
	@Value("${business.flow.url}")
	private String businessFlowURL;
	
	@Autowired
	private IHttpService httpService;
	@Autowired
	private IAlarmService alarmService;
	
	@Override
	public void notifyFundServer(AssetForm assetForm, Map<String, Object> data) {
		if (isDebug) { return; }
		Map<String, String> notifyMap = assetForm.transToNotifyMap(data);
		log.info("通知资金系统结果开始, uuid : {}, bizNo : {}, assetNo : {}, callbackUrl : {}, notifyForm : {}", assetForm.getUuid(), assetForm.getBizNo(), assetForm.getAssetNo(), assetForm.getCallbackUrl(), JSON.toJSONString(notifyMap));
		if (StringUtils.isEmpty(assetForm.getCallbackUrl())) { 
			log.info("通知资金系统结果失败，callbackUrl为空, uuid : {}, bizNo : {}, assetNo : {}, notifyForm : {}", assetForm.getUuid(), assetForm.getBizNo(), assetForm.getAssetNo(), JSON.toJSONString(notifyMap));
			return;
		}
		Map<String, String> response = httpService.postHasResponse(assetForm.getCallbackUrl(), notifyMap);
		log.info("通知资金系统结果结束, uuid : {}, bizNo : {}, assetNo : {}, callbackUrl : {}, notifyForm : {}, response : {}", assetForm.getUuid(), assetForm.getBizNo(), assetForm.getAssetNo(), assetForm.getCallbackUrl(), JSON.toJSONString(notifyMap), JSON.toJSONString(response));
		if(response==null || response.size()==0 || !"200".equals(response.get("statusCode")) || !"success".equals(response.get("response"))) {
			throw new QGException(QGExceptionType.NOTIFY_FUND_SERVER_ERROR, assetForm.getUuid(), assetForm.getBizNo(), assetForm.getAssetNo());
		}
	}

	@Override
	public void notifyBusinessFlow(String bizNo, Integer status) {
		try {
			if (isDebug) { return; }
			log.info("通知业务流系统订单终态开始, bizNo : {}, status : {}", bizNo, status);
			String response = httpService.post(businessFlowURL + "/ex/inner/accept_info", new HashMap<String, String>(){{
				put("applyNo", bizNo);
				put("status", status + "");
				put("type", "5");
			}});
			log.info("通知业务流系统订单终态结束, bizNo : {}, status : {}, response : {}", bizNo, status, response);
			JSONObject data = null;
			if (StringUtils.isEmpty(response) || (data = JSON.parseObject(response)).getInteger("code") != 0) {
				throw new QGException(QGExceptionType.NOTIFY_BUSINESS_FLOW_ERROR, bizNo, status);
	    	}
		} catch (QGException qe) {
			log.error("资产分发订单终态通知业务流系统出现错误, 错误信息 : {}, bizNo : {}, status : {}", qe.qgExceptionType.code + "->" + qe.detail, bizNo, status);
			alarmService.dingtalkAlarm("Warn", "通知业务流系统订单终态出现错误", "错误信息 : " + qe.qgExceptionType.code + "->" + qe.detail + " , bizNo : " + bizNo + " , " + "status : " + status);
		} catch (Exception e) {
			log.error("资产分发订单终态通知业务流系统异常, bizNo : {}, status : {}", bizNo, status);
			alarmService.dingtalkAlarm("Warn", "通知业务流系统订单终态异常", "bizNo : " + bizNo + " , " + "status : " + status);
		}
	}
}
