package com.quantgroup.asset.distribution.service.approval;

import java.util.Map;

import com.quantgroup.asset.distribution.enums.funding.AuditTargetEnum;
import com.quantgroup.asset.distribution.enums.funding.AuditTypeEnum;
import com.quantgroup.asset.distribution.service.jpa.entity.ApprovalLog;

/**
 * 
 * @author liwenbin
 *
 */
public interface IApprovalLogService {
	
	/**
	 * 创建审批记录
	 * @param auditType
	 * @param auditTarget
	 * @param targetName
	 * @param proposer
	 * @param auditor
	 * @param preConfigId
	 * @param auditConfigId
	 */
	public void createApprovalLog(AuditTypeEnum auditType, AuditTargetEnum auditTarget, String targetName, 
			String proposer, String auditor, Long preConfigId, Long auditConfigId);
	
	/**
	 * 获取审批记录
	 * @param targetName
	 * @param auditStatus
	 * @param auditType
	 * @param auditTarget
	 * @param applyStartTime
	 * @param applyEndTime
	 * @param user
	 * @param pageNum
	 * @param pageSize
	 * @return
	 */
	public Map<String, Object> getApprovalLogs(String targetName, Integer auditStatus, Integer auditType, Integer auditTarget,
			String applyStartTime, String applyEndTime, String user, Integer pageNum, Integer pageSize);
	
	/**
	 * 审批接口
	 * @param id 审批记录id
	 * @param auditStatus
	 */
	public void audit(ApprovalLog approvalLog, Integer auditStatus);
	
	/**
	 * 根据id获取审批记录
	 * @param id
	 * @return
	 */
	public ApprovalLog findById(Long id);
	
	/**
	 * 查询该条配置是否正在审批
	 * @param channelFundConfigId
	 * @return
	 */
	public Boolean isAuditing(Long channelFundConfigId);
}
