package com.quantgroup.asset.distribution.enums.response;

import lombok.Getter;

/**
 * 资方模块返回结果
 * @author liwenbin
 *
 */
public enum FundModuleResponse implements GlobalResponseEnum{
	
	SUCCESS(0, "success"),
	TYPE_IS_EMPTY(4001, "type不能为空"),
	UNKNOW_TYPE(4002, "未知的type类型"),
	ID_IS_EMPTY(4003, "id不能为空"),
	BIZ_CHANNEL_IS_EMPTY(4004, "渠道号不能为空"),
	FUNDS_INFO_IS_EMPTY(4005, "渠道资方信息不能为空"),
	FUNDS_INFO_ERROR(4006, "渠道资方信息有误，请检查"),
	CHANNEL_FUND_CONFIG_IS_EXIST(4007, "渠道资方配置已存在, 添加失败!"),
	CHANNEL_FUND_CONFIG_NOT_EXIST(4008, "渠道资方配置修改失败, id不存在!"),
	PAGEING_CONDITIONS_IS_EMPTY(4009, "分页条件不能为空"),
	HAS_NO_DATA(4010, "未找到数据"),
	AUDITOR_OR_PROPOSER_IS_EMPTY(4011, "申请人或审批人为空, 请检查!"),
	USER_IS_EMPTY(4012, "用户信息为空"),
	AUDIT_STATUS_IS_EMPTY(4013, "审批状态为空！"),
	UKNOW_AUDIT_STATUS(4014, "未知的审批状态"),
	CHANNEL_FUND_CONFIG_IS_AUDITING(4015, "该渠道资方配置正在审核中，不允许修改!");
	
	@Getter
	private int code;
	@Getter
	private String businessCode;
	@Getter
	private String msg;
	@Getter
	private Object body;
	
	FundModuleResponse(int code, String msg) {
		this.code = code;
		this.businessCode = null;
		this.msg = msg;
		this.body = null;
	}
}
