package com.quantgroup.asset.distribution.util;

import lombok.extern.slf4j.Slf4j;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Date;

/**
 * Created by renfeng on 2019/7/22.
 */
@Slf4j
public class DateUtil {

    public enum DateTimeUtilFormat {
        yyyyMMdd("yyyyMMdd"),
        yyyyMMddHHmm("yyyyMMddHHmm"),
        yyyyMMddHHmmss("yyyyMMddHHmmss"),
        yyyy_MM_dd("yyyy-MM-dd"),
        MM_dd("MM-dd"),
        yyyy_MM_dd_HH_mm("yyyy-MM-dd HH:mm"),
        yyyy_MM_dd_HH_mm_ss("yyyy-MM-dd HH:mm:ss"),
        yyyy_MM_dd_cn("yyyy年MM月dd日"),
        yyyy_MM("yyyy-MM"),
        MM_dd_HH_mm_cn("MM月dd日 HH:mm");
        String format;

        DateTimeUtilFormat(String format) {
            this.format = format;
        }
    }


    /**
     * 获取当前日期（天）
     * @return
     */
    public static String getDay(){
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(new Date());
    }
    
    /**
     * 获取当前时间 yyyy-MM-dd HH:mm:ss
     * @return
     */
    public static String getCurDateTime() {
    	return DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.now());
    }

    /**
     * 将时间类型字符串转换为Long类型
     * @param dateTime
     * @param pattern
     * @return
     */
    public static Long transStringToLong(String dateTime, String pattern) {
        return Timestamp.valueOf(LocalDateTime.parse(dateTime, DateTimeFormatter.ofPattern(pattern))).getTime();
    }

    /**
     * 获取格式化日期
     *
     * @param pattern
     * @param add
     * @return
     */
    public static String getStrFormatDate(String pattern, int add) {
        return LocalDateTime.now().plusDays(add).format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String timestamp2Str(String longmills, String pattern) {
        try {
            Timestamp ts = new Timestamp(Long.parseLong(longmills));
            return new SimpleDateFormat(pattern).format(ts);
        } catch (Exception e) {
            log.error("Timestamp转String异常,格式 : {}", pattern, e);
            return null;
        }
    }

    public static String toString(Date date, DateTimeUtilFormat dateTimeUtilFormat) {
        return new DateTime(date).toString(dateTimeUtilFormat.format);
    }

    public static DateTime toDateTime(String dateTime, DateTimeUtilFormat dateTimeUtilFormat) {
        return DateTimeFormat.forPattern(dateTimeUtilFormat.format).parseLocalDate(dateTime).toDateTimeAtStartOfDay();
    }

    public static Date localDateTimeToDate(LocalDateTime localDateTime) {
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zdt = localDateTime.atZone(zoneId);
        return Date.from(zdt.toInstant());
    }

    public static int getDays(Date time) {
        long days = ChronoUnit.DAYS.between(
                new Date().toInstant().atZone(ZoneId.systemDefault()).toLocalDate(),
                time.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
        return (int) days;
    }

    public static boolean between(String startData,String endData){
        LocalDate start = LocalDate.of(Integer.parseInt(startData.substring(0,4)) ,
                Integer.parseInt(startData.substring(4,6)),
                Integer.parseInt(startData.substring(6,8)));
        LocalDate end = LocalDate.of(Integer.parseInt(endData.substring(0,4)) ,
                Integer.parseInt(endData.substring(4,6)),
                Integer.parseInt(endData.substring(6,8)));
        return LocalDate.now().isBefore(end) && LocalDate.now().isAfter(start);
    }

    /**
     * 获取两个日期相差的月数
     */
    public static int getMonthDiff(String d1, String d2) {
        /*Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(d1);
        c2.setTime(d2);
        int year1 = c1.get(Calendar.YEAR);
        int year2 = c2.get(Calendar.YEAR);
        int month1 = c1.get(Calendar.MONTH);
        int month2 = c2.get(Calendar.MONTH);
        int day1 = c1.get(Calendar.DAY_OF_MONTH);
        int day2 = c2.get(Calendar.DAY_OF_MONTH);
        // 获取年的差值
        int yearInterval = year1 - year2;
        // 如果 d1的 月-日 小于 d2的 月-日 那么 yearInterval-- 这样就得到了相差的年数
        if (month1 < month2 || month1 == month2 && day1 < day2) {
            yearInterval--;
        }
        // 获取月数差值
        int monthInterval = (month1 + 12) - month2;
        if (day1 < day2) {
            monthInterval--;
        }
        monthInterval %= 12;
        return yearInterval * 12 + monthInterval;*/
        String text1 = "2020-08-02";
        Temporal temporal1 = LocalDate.parse(d1);
        String text2 = "2020-09-03";
        Temporal temporal2 = LocalDate.parse(d2);
        // 方法返回为相差月份
        return (int)ChronoUnit.MONTHS.between(temporal1, temporal2);
    }

    public static void main(String[] args) {
        System.out.println(between("20210722","20310722"));
    }
}
