package com.quantgroup.asset.distribution.service.niwodai.impl;

import cn.qg.ec.hbase.ocr.OCRIdCardDataService;
import cn.quantgroup.motan.bean.UserInfo;
import cn.quantgroup.motan.vo.UserSysResult;
import cn.quantgroup.tech.util.TechEnvironment;
import cn.quantgroup.user.IUserSdkService;
import cn.quantgroup.user.UserSdkServiceFactory;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Stopwatch;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.lkb.data.hbase.row.verify.OCRIdCardRow;
import com.quantgroup.asset.distribution.constant.AidFundConstants;
import com.quantgroup.asset.distribution.enums.UserLoanType;
import com.quantgroup.asset.distribution.exception.QGException;
import com.quantgroup.asset.distribution.exception.QGExceptionType;
import com.quantgroup.asset.distribution.model.form.AssetForm;
import com.quantgroup.asset.distribution.service.funding.IAidLoanFundUserTagService;
import com.quantgroup.asset.distribution.service.httpclient.IHttpService;
import com.quantgroup.asset.distribution.service.jpa.entity.Asset;
import com.quantgroup.asset.distribution.service.niwodai.INiwodaiAssetService;
import com.quantgroup.asset.distribution.service.niwodai.INiwodaiService;
import com.quantgroup.asset.distribution.service.niwodai.vo.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@Slf4j
@Service
public class NiwodaiAssetServiceImpl implements INiwodaiAssetService {

    @Autowired
    private IAidLoanFundUserTagService aidLoanFundUserTagService;
    @Autowired
    IHttpService iHttpService;
    @Autowired
    @Qualifier("httpClient")
    private CloseableHttpClient httpClient;
    @Autowired
    private INiwodaiService niwodaiService;
    @Value("${passportapi.http}")
    private String userSysUrl;
    private IUserSdkService userSdkService;

    private static Gson GSON = new Gson();

    @PostConstruct
    private void init() {
        if (TechEnvironment.isPro()){
            userSysUrl = "http://passportapi2.xyqb.com";
        }
        userSdkService = UserSdkServiceFactory.generateSDKService(userSysUrl, httpClient);
    }

    @Override
    public NiwodaiIncomingResultResponseVO incomingResult(String orderId){
        NiwodaiIncomingResultRequestVO vo = new NiwodaiIncomingResultRequestVO();
        vo.setOrderId(orderId);
        return niwodaiService.incoingResult(vo);
    }

    @Override
    public NiwodaiDataImportCheckResponseVO preAudit(String uuid, Map<String, Object> data) {
        NiwodaiDataImportCheckRequestVO requestVO = new NiwodaiDataImportCheckRequestVO();
        UserSysResult<UserInfo> userInfoByUuid = userSdkService.findUserInfoByUuid(uuid);
        if (!userInfoByUuid.isSuccess()){
            log.error("你我贷准入检查获取用户中心信息失败 uuid : {}",uuid);
            throw new QGException(QGExceptionType.GET_USER_INFO_ERROR);
        }
        // 因为渠道限制不一样，死条件先在代码里写死
        String phoneNo = userInfoByUuid.getData().getPhoneNo();
        if (phoneNo.startsWith("170") || phoneNo.startsWith("171")) {
            log.info("你我贷准入检查, 用户手机号段过滤, uuid : {}, phone : {}", uuid, getPhoneNoMask(phoneNo));
            return NiwodaiDataImportCheckResponseVO.createPassFalse();
        }
        // 年龄过滤, 23>= age <= 50 通过，其余拒绝
        Integer age = (Integer)data.get("user_age");
        if (age == null || age.intValue() < 23 || age.intValue() > 50) {
            log.info("你我贷准入检查, 用户年龄过滤, uuid : {}, age : {}", uuid, age);
            return NiwodaiDataImportCheckResponseVO.createPassFalse();
        }
        // 用户归属地过滤，西藏、新疆、福建过滤
        String province = (String)data.get("user_province_code");
        if (StringUtils.isEmpty(province) || province.startsWith("-999999") || "54".equals(province.trim()) || "65".equals(province.trim()) || "35".equals(province.trim())) {
            log.info("你我贷准入检查, 用户归属地过滤, uuid : {}, province : {}", uuid, province);
            return NiwodaiDataImportCheckResponseVO.createPassFalse();
        }
        // 黑名单过滤
        Integer countBlackList = (Integer)data.get("filter_user_info_in_black");
        if (countBlackList == null || countBlackList.intValue() > 0) {
            log.info("你我贷准入检查, 用户黑名单过滤, uuid : {}, countBlackList : {}", uuid, countBlackList);
            return NiwodaiDataImportCheckResponseVO.createPassFalse();
        }
        requestVO.setPhone(getPhoneNoMask(phoneNo));
        requestVO.setIdcardNumber(getIdNoMask(userInfoByUuid.getData().getIdNo()));
        requestVO.setRealName(userInfoByUuid.getData().getName());
        Stopwatch stopwatch = Stopwatch.createStarted();
        NiwodaiDataImportCheckResponseVO responseVO = niwodaiService.dataImportCheck(requestVO, uuid);
        log.info("你我贷准入接口调用完成, uuid : {}, requestVo : {}, responseVo : {}, 耗时 : {}", uuid, JSON.toJSONString(requestVO), JSON.toJSONString(responseVO), stopwatch.stop().elapsed(TimeUnit.SECONDS));
        return responseVO;
    }


    @Override
    public NiwodaiIncomingResponseVO incoming(AssetForm assetForm, Map<String, Object> data, Asset asset) {
        List<OCRIdCardRow> list = OCRIdCardDataService.get(assetForm.getUuid());
        if (CollectionUtils.isEmpty(list)) {
            log.error("你我贷进件申请获取用户OCR信息失败 uuid : {}, orderId : {}",assetForm.getUuid(), assetForm.getBizNo());
            throw new QGException(QGExceptionType.OCR_DATA_MISS);
        }
        OCRIdCardRow ocrIdCardRow = list.get(0);
        UserSysResult<UserInfo> userInfoByUuid = userSdkService.findUserInfoByUuid(assetForm.getUuid());
        if (!userInfoByUuid.isSuccess()){
            log.error("你我贷进件申请获取用户中心信息失败, uuid : {}, orderId : {}", assetForm.getUuid(), assetForm.getBizNo());
            throw new QGException(QGExceptionType.GET_USER_INFO_ERROR);
        }
        IdCardA idCardFront = JSON.parseObject(ocrIdCardRow.getIdCardContentA(), IdCardA.class);
        IdCardB idCardBack = JSON.parseObject(ocrIdCardRow.getIdCardContentB(), IdCardB.class);
        Map<String,Object> infoMap = queryUserBasic2Info(assetForm.getUuid(), userInfoByUuid.getData().getPhoneNo(),true);
        NiwodaiIncomingRequestVO vo = new NiwodaiIncomingRequestVO();
        vo.setOrderId(assetForm.getBizNo());
        NiwodaiCostant.UserInfo userInfo = new NiwodaiCostant.UserInfo();
        userInfo.setRealName(idCardFront.getName());
        userInfo.setIdcardNumber(idCardFront.getCitizen_id().replaceAll("x", "X"));
        userInfo.setPhone(userInfoByUuid.getData().getPhoneNo());
        userInfo.setMaritalStatus(conversMarryStatus((String) infoMap.get("marryStatus")).name());
        userInfo.setGender("男".equals(idCardFront.getGender()) ? NiwodaiCostant.Gender.MALE.name() : NiwodaiCostant.Gender.FEMALE.name());
        userInfo.setEducation(conversEducation((String) infoMap.get("education")).name());
        userInfo.setOccupation(conversOccupation((String) infoMap.get("vocation")).name());
        userInfo.setIdcardValidity(idCardBack.getValid_date_begin() + "-" + idCardBack.getValid_date_end());
        userInfo.setIdcardFront(ocrIdCardRow.getIdCardBaseContentA().replaceAll("\r\n", ""));
        userInfo.setIdcardBack(ocrIdCardRow.getIdCardBaseContentB().replaceAll("\r\n", ""));
        userInfo.setBioPhoto(ocrIdCardRow.getLivePhotoContent().replaceAll("\r\n", ""));
        userInfo.setImageType("BASE64");
        userInfo.setProvince((String) infoMap.get("province"));
        userInfo.setCity((String) infoMap.get("city"));
        userInfo.setDistrict((String) infoMap.get("district"));
        userInfo.setAddress(idCardFront.getAddress());
        userInfo.setIndustry(conversIndustry((String) infoMap.get("vocation")).name());
        userInfo.setIncome(conversIncome((String) infoMap.get("salary")).name());
//        userInfo.setIncomeType(random(NiwodaiCostant.IncomeType.values()).name());
        userInfo.setDebt(NiwodaiCostant.Debt.ZERO.name());
        vo.setUserInfo(userInfo);
        NiwodaiCostant.LoanInfo loanInfo = new NiwodaiCostant.LoanInfo();
        // 写死
        loanInfo.setAmount(new BigDecimal(12000));
        loanInfo.setTerm(12);
        loanInfo.setPurpose(NiwodaiCostant.Purpose.CONSUMPTION.name());
        vo.setLoanInfo(loanInfo);
        NiwodaiCostant.Contacts contacts = new NiwodaiCostant.Contacts();
        String firstName = (String) infoMap.get("firstName");
        String firstMobile = (String) infoMap.get("firstMobile");
        String firstRelation =  (String)infoMap.get("firstRelation");
        if (StringUtils.isAnyEmpty(firstName, firstMobile, firstRelation)) {
            log.info("你我贷进件审核接口用户联系人1为空, 按拒绝处理, uuid : {}, bizNo : {}, firstName : {}, firstMobile : {}, firstRelation : {}",
                    assetForm.getUuid(), assetForm.getBizNo(), firstName, firstMobile, firstRelation);
            return NiwodaiIncomingResponseVO.createRejectVo();
        }
        contacts.setNameA(firstName);
        contacts.setPhoneA(firstMobile);
        contacts.setRelationshipA(conversRelationship(firstRelation).name());
        String secondName = (String) infoMap.get("secondName");
        String secondMobile = (String) infoMap.get("secondMobile");
        String secondRelation =  (String)infoMap.get("secondRelation");
        if (StringUtils.isAnyEmpty(secondName, secondMobile, secondRelation)) {
            log.info("你我贷进件审核接口用户联系人2为空, 按拒绝处理, uuid : {}, bizNo : {}, secondName : {}, secondMobile : {}, secondRelation : {}",
                    assetForm.getUuid(), assetForm.getBizNo(), secondName, secondMobile, secondRelation);
            return NiwodaiIncomingResponseVO.createRejectVo();
        }
        contacts.setNameB(secondName);
        contacts.setPhoneB(secondMobile);
        contacts.setRelationshipB(conversRelationship(secondRelation).name());
        vo.setContacts(contacts);
        NiwodaiCostant.CompnayInfo compnayInfo = new NiwodaiCostant.CompnayInfo();
        compnayInfo.setName(random(NiwodaiCostant.COMPANY_NAMES));
        compnayInfo.setAddress(userInfo.getProvince() + userInfo.getCity() + compnayInfo.getName());
        compnayInfo.setCity(userInfo.getCity());
        compnayInfo.setProvince(userInfo.getProvince());
        vo.setCompanyInfo(compnayInfo);
        vo.setMnoData(new NiwodaiCostant.MnoData());
        NiwodaiCostant.RiskData riskData = getRiskData(asset.getUserLoanType(), data);
        vo.setChannelRiskData(JSON.toJSONString(riskData));
        // 标签落库
        aidLoanFundUserTagService.saveUserTag(assetForm, asset, AidFundConstants.FundId.NIWODAI, JSON.toJSONString(riskData));
        return niwodaiService.incoming(vo, assetForm.getUuid());
    }


    private static <T> T random(T[] objects){
        int index = (int) (Math.random() * objects.length);
        return objects[index];
    }

    @Override
    public Map<String,Object> queryUserBasic2Info(String userId, String phoneNo, boolean isQuery) {
        String url = userSysUrl+"/innerapi/user-association/search/userId?phoneNo="+phoneNo;
        Map<String,Object> mapResult = new HashMap<>();
        try{
            String result = iHttpService.get(url);
            JSONObject resultJson = JSON.parseObject(result);
            if(queryIsSuccess(resultJson)){
                mapResult.put("checkResult", true);
                BasicInfo2Detail basicInfo2Detail = GSON.fromJson(resultJson.getString("data"), new TypeToken<BasicInfo2Detail>(){}.getType());
                Map<String,Object> convertMap = new HashMap<>();
                check(basicInfo2Detail, mapResult, userId, convertMap);
                if(!isQuery){
                    mapResult.put("info", "");
                }else{
                    mapResult.put("info", convertMap);
                }
                mapResult.put("name", basicInfo2Detail.getName());
            }else{
                mapResult.put("checkResult", false);
            }
        }catch(Exception e){
            mapResult.put("checkResult", false);
            log.error("查询用户中心数据发生异常, userId: {} ", userId, e);
        }
        if (null == mapResult.get("info")){
            return new HashMap<>();
        }else {
            return (Map<String, Object>) mapResult.get("info");
        }
    }

    public static void check(BasicInfo2Detail basicInfo2Detail, Map<String,Object> map, String userId, Map<String,Object> convertMap){
        valuesChecker(basicInfo2Detail, map, userId);
        String vocation = basicInfo2Detail.getOccupationEnum();
        if(StringUtils.isNotEmpty(vocation)){
            convertMap.put("vocation", basicInfo2Detail.getOccupationEnum());
        }
        String salary = basicInfo2Detail.getIncomeRangeEnum();
        if(StringUtils.isNotEmpty(salary)){
            convertMap.put("salary", basicInfo2Detail.getIncomeRangeEnum());
        }
        String education = basicInfo2Detail.getEducationEnum();
        if(StringUtils.isNotEmpty(education)){
            convertMap.put("education", basicInfo2Detail.getEducationEnum());
        }
        String email = basicInfo2Detail.getEmail();
        if(StringUtils.isNotEmpty(email)){
            convertMap.put("email", basicInfo2Detail.getEmail());
        }
        String marryStatus = basicInfo2Detail.getMarryStatus();
        if (StringUtils.isNotEmpty(marryStatus)){
            convertMap.put("marryStatus",basicInfo2Detail.getMarryStatus());
        }
        List<Contacts> contacts = basicInfo2Detail.getContactList();
        List<Address> addresses = basicInfo2Detail.getAddressList();
        if(contacts!=null && contacts.size()>0){
            for(int i=0;i<contacts.size();i++){
                Contacts contacts1 = contacts.get(i);
                if(i==0){
                    String firstName = contacts1.getName();
                    if(StringUtils.isNotEmpty(firstName)){
                        convertMap.put("firstName", contacts1.getName());
                    }
                    String firstMobile = contacts1.getPhoneNo();
                    if(StringUtils.isNotEmpty(firstMobile)){
                        convertMap.put("firstMobile", contacts1.getPhoneNo());
                    }
                    String relation = contacts1.getRelationName();
                    if(StringUtils.isNotEmpty(relation)){
                        convertMap.put("firstRelation", contacts1.getRelationName());
                    }
                }else if(i==1){
                    String secondName = contacts1.getName();
                    if(StringUtils.isNotEmpty(secondName)){
                        convertMap.put("secondName", contacts1.getName());
                    }
                    String secondMobile = contacts1.getPhoneNo();
                    if(StringUtils.isNotEmpty(secondMobile)){
                        convertMap.put("secondMobile", contacts1.getPhoneNo());
                    }
                    String secondRelation = contacts1.getRelationName();
                    if(StringUtils.isNotEmpty(secondRelation)){
                        convertMap.put("secondRelation", contacts1.getRelationName());
                    }
                }
                valuesChecker(contacts1, map, userId);
            }
            if(contacts.size()<2) {
                map.put("checkResult", false);
            }
        }
        if(addresses!=null && addresses.size()>0){
            Address address = addresses.get(0);
            valuesChecker(address, map, userId);
            Long provinceCode = address.getProvinceCode();
            if(provinceCode!=null){
                convertMap.put("provinceCode", address.getProvinceCode());
            }
            String province = address.getProvince();
            if(StringUtils.isNotEmpty(province)){
                convertMap.put("province", address.getProvince());
            }
            Long cityCode = address.getCityCode();
            if(cityCode!=null){
                convertMap.put("cityCode", address.getCityCode());
            }
            String city = address.getCity();
            if(StringUtils.isNotEmpty(city)){
                convertMap.put("city", address.getCity());
            }
            Long districtCode = address.getDistrictCode();
            if(districtCode!=null){
                convertMap.put("districtCode", address.getDistrictCode());
            }
            String district = address.getDistrict();
            if(StringUtils.isNotEmpty(district)){
                convertMap.put("district", address.getDistrict());
            }
            String address1 = address.getAddress();
            if(StringUtils.isNotEmpty(address1)){
                convertMap.put("address", address.getAddress());
            }
        }
    }

    public boolean queryIsSuccess(JSONObject resultJson){
        if("0000".equals(resultJson.getString("code")) && "0000".equals(resultJson.getString("businessCode"))){
            String userInfo = resultJson.getString("data");
            if(StringUtils.isNotEmpty(userInfo)){
                return true;
            }
        }
        return false;
    }

    public static void valuesChecker(Object o, Map<String,Object> map, String userId){
        try{
            Field[] fields = o.getClass().getDeclaredFields();
            Object[] values = new Object[fields.length];
            Object[] names = new Object[fields.length];
            for(int i=0;i<names.length;i++){
                fields[i].setAccessible(true);
                values[i] = fields[i].get(o);
                if(values[i]==null || "".equals(values[i]) || "未知".equals(values[i]) || "暂未填写".equals(values[i])){
                    map.put("checkResult", false);
                    break;
                }
            }
        }catch(Exception e){
            map.put("checkResult", false);
            log.error("校验基本信息参数异常, userId:{}", userId, e);
        }
    }

    private static NiwodaiCostant.Industry conversIndustry(String occupation) {
        switch (occupation) {
            case ("工人") : return NiwodaiCostant.Industry.AGRICULTURE;
            case ("教师") : return NiwodaiCostant.Industry.EDUCATION;
            case ("白领") : return NiwodaiCostant.Industry.INFORMATION_TECHNOLOGY_SERVICES;
            case ("学生") : return NiwodaiCostant.Industry.EDUCATION;
            case ("创业者") : return NiwodaiCostant.Industry.TECHNOLOGICAL_SERVICES;
            case ("个体户") : return NiwodaiCostant.Industry.RETAIL;
            case ("公司职员") : return NiwodaiCostant.Industry.FINANCE;
            case ("企业法人") : return NiwodaiCostant.Industry.ESTATE;
            case ("网店店主") : return NiwodaiCostant.Industry.ENTERTAINMENT;
            case ("暂无职业") :
            case ("其他") :
            default : return NiwodaiCostant.Industry.UNKNOWN;
        }
    }

    private static NiwodaiCostant.Occupation conversOccupation(String occupation){
        switch (occupation){
            case ("工人") :
            case ("教师") :
            case ("白领") :
            case ("公司职员") :
                return NiwodaiCostant.Occupation.WORKER;
            case ("学生") : return NiwodaiCostant.Occupation.STUDENT;
            case ("创业者") :
            case ("企业法人") : return NiwodaiCostant.Occupation.PRIVATE_OWNERS;
            case ("个体户") :
                return NiwodaiCostant.Occupation.BUSINESSMEN;
            case ("网店店主") :
            case ("其他") : return NiwodaiCostant.Occupation.PROFESSIONAL;
            case ("暂无职业") :
            default : return NiwodaiCostant.Occupation.BE_UNEMPLOYED;
        }
    }
    private static NiwodaiCostant.EducationalBackground conversEducation(String education){
        switch (education){
            case ("小学"):
            case ("初中") : return NiwodaiCostant.EducationalBackground.JUNIOR_SCHOOL_AND_BELOW;
            case ("高中"):
            case ("技校"):
            case ("中专"): return NiwodaiCostant.EducationalBackground.HIGH_SCHOOL;
            case ("大专") : return NiwodaiCostant.EducationalBackground.ACADEMY;
            case ("本科") : return NiwodaiCostant.EducationalBackground.UNIVERSITY;
            case ("硕士及以上") : return NiwodaiCostant.EducationalBackground.POSTGRADUATE_AND_ABOVE;
            default:return NiwodaiCostant.EducationalBackground.JUNIOR_SCHOOL_AND_BELOW;
        }
    }

    private static NiwodaiCostant.Income conversIncome(String income){
        switch (income){
            case ("1000至3000元"): return NiwodaiCostant.Income.ONE;
            case ("3000至5000元"): return NiwodaiCostant.Income.TWO;
            case ("5000至8000元"):
            case ("8000至10000元"): return NiwodaiCostant.Income.THREE;
            case ("10000至15000元"): return NiwodaiCostant.Income.FOUR;
            case ("15000至20000元"): return NiwodaiCostant.Income.FIVE;
            case ("大于20000元"): return NiwodaiCostant.Income.SIX;
            case ("小于1000元"):
            default:return NiwodaiCostant.Income.ZERO;
        }
    }

    private static NiwodaiCostant.MaritalStatus conversMarryStatus(String marryStatus){
        switch (marryStatus){
            case ("已婚") : return NiwodaiCostant.MaritalStatus.MARRIED;
            case ("离异") : return NiwodaiCostant.MaritalStatus.DIVORCE;
            case ("丧偶") : return NiwodaiCostant.MaritalStatus.WIDOWEDSPOUSE;
            case ("未知") :
            case ("未婚") :
            default:return NiwodaiCostant.MaritalStatus.UNMARRIED;
        }
    }

    private static NiwodaiCostant.Relationship conversRelationship(String relationship){
        switch (relationship){
            case ("父母") : return NiwodaiCostant.Relationship.MOTHER;
            case ("子女") : return NiwodaiCostant.Relationship.SON;
            case ("兄弟姐妹") : return NiwodaiCostant.Relationship.BROTHER;
            case ("同事") : return NiwodaiCostant.Relationship.COLLEAGUE;
            case ("同学") : return NiwodaiCostant.Relationship.CLASSMATE;
            case ("朋友") : return NiwodaiCostant.Relationship.FRIEND;
            case ("夫妻") : return NiwodaiCostant.Relationship.SPOUSE;
            case ("本人") :
            case ("其他")  :
            default: return NiwodaiCostant.Relationship.OTHER;
        }
    }

    /**
     * 获取手机号掩码，后4位掩码
     * @param phoneNo
     * @return
     */
    private static String getPhoneNoMask(String phoneNo) {
        if (StringUtils.isEmpty(phoneNo)) { throw new QGException(QGExceptionType.USER_PHONE_NO_EMPTY); }
        return phoneNo.substring(0, phoneNo.length() - 4) + "****";
    }

    /**
     * 身份证号掩码，后5位掩码
     * @param idNo
     * @return
     */
    private static String getIdNoMask(String idNo) {
        if (StringUtils.isEmpty(idNo)) { throw new QGException(QGExceptionType.USER_ID_NO_EMPTY); }
        return idNo.substring(0, idNo.length() - 5) + "*****";
    }

    /**
     * 获取用户标签
     * @param data
     * @return
     */
    private Integer getUserTag(int userLoanType, Map<String, Object> data) {
        if (userLoanType == UserLoanType.FIRST_APPLY.getCode() || userLoanType == UserLoanType.RE_APPLY.getCode()) {
            return NiwodaiCostant.Tag.NATURE;
        } else {
            if (data.get("model_exec_data_source#xinyan_v5") != null && data.get("third_data_source#tencent_md5_risk_new_riskScore") != null) {
                return NiwodaiCostant.Tag.REJECT;
            } else {
                return NiwodaiCostant.Tag.NATURE;
            }
        }
    }

    /**
     * 获取风控分数
     * @param data
     * @param key
     * @return
     */
    private BigDecimal getRiskScore(Map<String, Object> data, String key) {
        return data.get(key) == null ? new BigDecimal(-9999999) : new BigDecimal(String.valueOf(data.get(key)));
    }

    /**
     * 获取风控数据对象
     * @param userLoanType
     * @param data
     * @return
     */
    private NiwodaiCostant.RiskData getRiskData(int userLoanType, Map<String, Object> data) {
        NiwodaiCostant.RiskData riskData = new NiwodaiCostant.RiskData();
        riskData.setIn_label(String.valueOf(getUserTag(userLoanType, data)));
        riskData.setRisk_score2(getRiskScore(data, "model_exec_data_source#xinyan_v5"));
        riskData.setRisk_score3(getRiskScore(data, "third_data_source#tencent_md5_risk_new_riskScore"));
        return riskData;
    }

    public static void main(String[] args) {
        Map<String, Object> map = new HashMap<>();
        System.out.println((String) map.get("firstName"));

        String str = (String) map.get("riffs");

        switch (str) {
            case "asdf" :
                System.out.println(1);
                break;
            default:
                System.out.println(2);
                break;
        }


    }
}
