package com.quantgroup.asset.distribution.service.newrule.third;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;

/**
 * @author shihuajun
 * @date 2021/8/26 19:28
 * @ describing  http://yapi.quantgroups.com/project/49/interface/api/5685
 */
@Data
public class AuditResponce {
    private Integer code;
    private String msg;
    //用户UUID
    @NotNull
    @Length(min = 1)
    private String uuid;
    @NotNull
    private String bizChannel;
    //业务唯一编号
    @NotNull
    private String bizNo;
    //业务类型  0-循环额度现金分期 1-循环额度白条 2-现金分期  3-白条
    private String bizType;
    //扩展参数
    private String exData;
    //其他信息
    private String otherInformation;

    //审核结果
    @NotNull
    private Boolean auditResult;
    //额度
    @NotNull
    private String amount;
    //期数
    @NotNull
    private String term;
    // 有效期, int类型, 天数
    @NotNull
    private String validity;
    //有效截止时间
    @NotNull
    private Long deadLine;
    // vcc-开户有效天数, int类型
    private String openingValidity;
    // vcc-开户有效截止时间
    @NotNull
    private Long openingDeadLine;
    //金融产品集
    private String financeProducts;

    //新颜分
    private String xycreditScore;
    //用户等级
    private String creditLevel;

    //回调通知地址
    @NotNull
    @Length(min = 1)
    private String callbackUrl;

    private String refuseReason;

    // 额度、期数限制列表
    private String amountTermLimits;
    // 额度变化率
    private String amountRate;

    // 渠道方要求利率，目前只给乐信渠道用
    private String fundRate;

    // 是否导流VCC，1-导流, 0-不导流
    private String exportVccTag;

    /**
     * 是否允许账单分期
     */
    private String allowInstalment;

    /**
     * 允许账单分期数
     */
    private String allowInstalmentTerms;

    /**
     * 场景id：
     * 0-授信额度审核
     * 1-下单审核
     * 2-KA进件准入审核
     * 3-多订单筛选审核
     * 4-微店快速额度审核
     * 5-vcc贷中商户预警审核
     * 6-vcc贷中交易反欺诈审核
     * ...
     */
    @NotNull(message = "sceneId不能为空")
    private Integer sceneId;

    private String isWhiteBlackListHit;

    /**
     * 是否命中熔断模块
     */
    private String isFuseModuleHit;

    /**
     * 二次验证规则
     */
    private String secondaryValidation;

    /**
     * 额度支付金额
     */
    private String quotaPaymentAmount;

    /**
     * 特殊用户名单
     */
    private String specialUserList;

    private String userTag;

}
