package com.quantgroup.asset.distribution.distribute;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.quantgroup.asset.distribution.AssetDistributionBootstrap;
import com.quantgroup.asset.distribution.model.entity.DistributeRecord;
import com.quantgroup.asset.distribution.service.distribute.IAssetDistributeRecordService;
import com.quantgroup.asset.distribution.service.jpa.entity.AssetDistributeRecord;

@SpringBootTest(classes = AssetDistributionBootstrap.class)
@RunWith(SpringRunner.class)
public class DistributeTest {
	
	@Autowired
	private IAssetDistributeRecordService assetDistributeRecordService;
	
	@Test
	public void test() {
		List<AssetDistributeRecord> assetDistributeRecords = assetDistributeRecordService.getDistributeRecord("ASET0645dd8bdbe5458dacccad57ab22fbaf");
		List<Integer> list = new ArrayList<>();
		for (AssetDistributeRecord assetDistributeRecord : assetDistributeRecords) {
			JSONArray array = JSON.parseObject(assetDistributeRecord.getAssetDistributeTravel()).getJSONArray("records");
			for (int i = 0, len = array.size(); i < len; ++i) {
				JSONObject record = array.getJSONObject(i);
				list.add(record.getInteger("type"));
			}
		}
		System.out.println(list);
	}
}
