package com.quantgroup.asset.distribution.enums.route;

import lombok.Getter;

/**
 * @author shihuajun
 * @date 2021/8/21 9:07
 * @ describing
 */
@Getter
public enum UserTag {
    /**
     * 用户标签
     */
    INITIAL_APPLICATION("INITIAL_APPLICATION","首申"),
    REAPPLICATION("REAPPLICATION","复申"),
    RE_LOAN("RE_LOAN","复贷"),
//    NO_ABLES("NO_ABLES","无标签"),
//    OTHERS("OTHERS","其他"),
    ;

    private String value;

    private String desc;

    UserTag(String value, String desc){
        this.value = value;
        this.desc = desc;
    }

    public static UserTag getByOrder(Integer order) {
        UserTag[] values = UserTag.values();
        for (UserTag value : values) {
            if (order.intValue() == value.ordinal()) {
                return value;
            }
        }
        return null;
    }
}
