package com.quantgroup.asset.distribution.service.funding.impl;

import com.quantgroup.asset.distribution.service.funding.IAidLoanFundConfigService;
import com.quantgroup.asset.distribution.service.jpa.entity.AidLoanFundConfig;
import com.quantgroup.asset.distribution.service.jpa.repository.IAidLoanFundConfigRepository;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

import static com.quantgroup.asset.distribution.constant.FundingConstants.AID_LOAN_FUND_CONFIG_LIST;

/**
 * Created by renfeng on 2019/7/22.
 */
@Service
@Slf4j
public class AidLoanFundConfigServiceImpl implements IAidLoanFundConfigService {

    @Autowired
    private IAidLoanFundConfigRepository iAidLoanFundConfigRepository;

    /**
     * 查询全部可用助贷资金
     *
     * @return
     */
    @Override
    public List<AidLoanFundConfig> findAll() {
        if(AID_LOAN_FUND_CONFIG_LIST.size()<1) {
            List<AidLoanFundConfig> aidLoanFundConfigs = iAidLoanFundConfigRepository.findByEnableTrue();
            if (CollectionUtils.isEmpty(aidLoanFundConfigs))
                AID_LOAN_FUND_CONFIG_LIST.addAll(aidLoanFundConfigs);

        }
        return AID_LOAN_FUND_CONFIG_LIST;
    }

    /**
     * 根据id查询助贷资金
     *
     * @param id
     * @return
     */
    @Override
    public AidLoanFundConfig findById(Long id) {
        return iAidLoanFundConfigRepository.findOne(id);
    }

    /**
     * 根据编号查询助贷资金
     *
     * @param fundNo
     * @return
     */
    @Override
    public AidLoanFundConfig findByFundNo(String fundNo) {
        return iAidLoanFundConfigRepository.findByFundNo(fundNo);
    }
}
