package com.quantgroup.asset.distribution.controller;

import java.util.concurrent.TimeUnit;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Stopwatch;
import com.quantgroup.asset.distribution.enums.response.AssetResponse;
import com.quantgroup.asset.distribution.model.form.AssetForm;
import com.quantgroup.asset.distribution.model.response.GlobalResponse;
import com.quantgroup.asset.distribution.service.IAssetService;
import com.quantgroup.asset.distribution.util.UUIDUtil;

import lombok.extern.slf4j.Slf4j;

/**
 * 资产入库Controller
 * @author liwenbin
 *
 */
@RestController
@Slf4j
@RequestMapping("/biz")
public class AssetController {
	
	@Autowired
	private IAssetService assetService;
	
	@RequestMapping("/asset_in")
	public GlobalResponse assetsIn(AssetForm assetForm) {
		Stopwatch stopwatch = Stopwatch.createStarted();
		assetForm.setAssetNo(UUIDUtil.getAssetNo());
		log.info("资产入库开始, assetForm : {}", JSON.toJSONString(assetForm));
		GlobalResponse response = assetService.checkAssetForm(assetForm);
		assetService.assetsIn(assetForm);
		log.info("资产入库结束, assetForm : {}, response : {}, 耗时 : {}", JSON.toJSONString(assetForm), JSON.toJSONString(response), stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
		return response;
	}
}
