package com.quantgroup.asset.distribution.enums.response;

import lombok.Getter;

/**
 * @author : Hyuk
 * @description : MiddleOfficeCommonResponseEnum
 * @date : 2020/6/4 6:29 下午
 */
public enum MiddleOfficeCommonResponseEnum {

    // 0-success
    SUCCESS("0", "success"),

    // 4**客户端错误
    // 401-权限错误
    AUTH_ERROR("401", "权限校验失败"),
    // 402-流量限制, 请求频繁
    REQUEST_LIMIT("402", "请求次数过多"),
    // 403-参数错误
    REQUEST_PARAMS_ERROR("403", "参数有误"),
    // 404-请求地址错误
    REQUEST_URL_ERROR("404", "请求地址错误"),
    // 405-并发错误, 客户端在一定维度单线程调用
    CONCURRENT_REQUEST("405", "存在未结束的请求, 不允许再次调用"),
    // 406-行为错误，客户端应该更换后续行为。此路不通，应该更换其他执行路径
    REQUEST_PATH_ERROR("406", "行为错误，当前不能调用此接口"),

    // 5**服务端错误
    // 501-中间件错误
    MIDDLEWARE_ERROR("407", "中间件服务出现异常"),
    // 502-第三方服务不可用
    THIRD_SERVER_ERROR("502", "第三方服务出现异常"),

    // 600-未知错误
    UN_KNOW_ERROR("600", "未知错误");


    @Getter
    private String code;
    @Getter
    private String msg;

    MiddleOfficeCommonResponseEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }
}
