package com.quantgroup.asset.distribution.model.entity.user;

import lombok.Data;

import java.io.Serializable;

/**
 * @author : Hyuk
 * @description : UserAddressInfo
 * @date : 2020/6/27 3:55 上午
 */
@Data
public class UserAddressInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    private Integer provinceCode;

    private String province;

    private Integer cityCode;

    private String city;

    private Integer districtCode;

    private String district;

    private String address;

    public String getAddressDetail() {
        StringBuilder address = new StringBuilder();
        if (this.province != null) {
            address.append(this.province);
        }
        if (this.city != null) {
            address.append(this.city);
        }
        if (this.district != null) {
            address.append(this.district);
        }
        if (this.address != null) {
            address.append(this.address);
        }
        return address.toString();
    }
}
