package com.quantgroup.asset.distribution.enums.response;

import lombok.Getter;

/**
 * 资产系统返回值
 * @author liwenbin
 *
 */
public enum AssetResponse implements GlobalResponseEnum{
	
	SUCCESS(0, "success"),
	ASSET_FORM_IS_ERROR(2001, "资产入库参数错误!");
	
	@Getter
	private int code;
	@Getter
	private String businessCode;
	@Getter
	private String msg;
	@Getter
	private Object body;
	
	AssetResponse(int code, String msg) {
		this.code = code;
		this.businessCode = null;
		this.msg = msg;
		this.body = null;
	}
	
	AssetResponse(int code, String businessCode, String msg) {
		this.code = code;
		this.businessCode = businessCode;
		this.msg = msg;
	}
}
