package com.quantgroup.asset.distribution.service.alarm.impl;

import java.util.HashMap;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import com.quantgroup.asset.distribution.service.alarm.IAlarmService;
import com.quantgroup.asset.distribution.service.httpclient.IHttpService;

import lombok.extern.slf4j.Slf4j;

/**
 * 报警接口
 * @author liwenbin
 *
 */
@Slf4j
@Service
public class AlarmServiceImpl implements IAlarmService{
	
	private static final String ALARM_HTTP_URL = "http://alertserv-dataservice.quantgroup.cn/common/alert/dingtalk";
	private static final String ROBOT_WEB_HOOK = "https://oapi.dingtalk.com/robot/send?access_token=53a55ffe3d4a5398a7ba44e4fcee1a3ac006edcba9cfdc4b1f9f692ffc18a5b8";
	
	@Value("${isDebug}")
    private Boolean isDebug;
	@Autowired
	private IHttpService httpService;
	
	@Async
	@Override
	public void dingtalkAlarm(String alarmLevel, String msgTitle, String msgContent) {
		try {
			// TODO
			if (isDebug) { return; }
			Map<String, String> params = new HashMap<>();
			params.put("webhook", ROBOT_WEB_HOOK);
			params.put("alarmLevel", alarmLevel);
			params.put("msgTitle", msgTitle);
			params.put("msgContent", msgContent);
			httpService.postNoResponse(ALARM_HTTP_URL, params);
		} catch (Exception e) {
			log.error("钉钉机器人报警异常, msg : {}", msgContent, e);
		}
	}
}
