package com.quantgroup.asset.distribution.service.asset.impl;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.quantgroup.asset.distribution.constant.DistributeLogoConstants;
import com.quantgroup.asset.distribution.exception.QGException;
import com.quantgroup.asset.distribution.exception.QGExceptionType;
import com.quantgroup.asset.distribution.exception.QGPreconditions;
import com.quantgroup.asset.distribution.model.form.AssetForm;
import com.quantgroup.asset.distribution.model.response.GlobalResponse;
import com.quantgroup.asset.distribution.service.alarm.IAlarmService;
import com.quantgroup.asset.distribution.service.asset.IAssetAttributeExtendConfigService;
import com.quantgroup.asset.distribution.service.asset.IAssetAttributeService;
import com.quantgroup.asset.distribution.service.asset.IAssetService;
import com.quantgroup.asset.distribution.service.distribute.IAssetDistributeService;
import com.quantgroup.asset.distribution.service.distribute.IDistributeFailLogService;
import com.quantgroup.asset.distribution.service.httpclient.IHttpService;
import com.quantgroup.asset.distribution.service.jpa.entity.Asset;
import com.quantgroup.asset.distribution.service.jpa.entity.AssetAttributeExtendConfig;
import com.quantgroup.asset.distribution.service.jpa.repository.IAssetAttributeExtendConfigRepository;
import com.quantgroup.asset.distribution.util.UUIDUtil;

import lombok.extern.slf4j.Slf4j;

/**
 * 资产Service
 * @author liwenbin
 *
 */
@Slf4j
@Service
public class AssetServiceImpl implements IAssetService{
	
	@Autowired
	private IAssetAttributeExtendConfigService assetAttributeExtendConfigService;
	@Autowired
	private IAssetAttributeService assetAttributeService;
	@Autowired
	private IAssetDistributeService assetDistributeService;
	@Autowired
	private IAlarmService alarmService;
	@Autowired
	private IDistributeFailLogService distributeFailLogService;
	
	
	@Async
	@Override
	public void assetsIn(AssetForm assetForm) {
		try {
			Asset asset = assetForm.transToAsset();
			// 获取所有资产扩展属性配置
			List<AssetAttributeExtendConfig> assetAttributeExtendConfigList = assetAttributeExtendConfigService.getAllExtendConfig();
			// 获取所有资产扩展属性值
			Map<String, Object> data = assetAttributeService.getAllAssetAttributeValue(assetAttributeExtendConfigList, assetForm);
			// 资产入库
			assetAttributeService.saveAssetAttrubite(asset, assetAttributeExtendConfigList, data);
			// 资产分发
			assetDistributeService.distribute(assetForm, asset, data, DistributeLogoConstants.FIRST);
		} catch (QGException qe) {
			log.error("资产入库分发出现错误 : {}, uuid : {}, bizChannel : {}, bizType : {}, bizNo : {}, assetNo : {} ",
					qe.qgExceptionType.code + "->" + qe.detail, assetForm.getUuid(), 
					assetForm.getBizChannel(), assetForm.getBizType(),
					assetForm.getBizNo(), assetForm.getAssetNo());
			distributeFailLogService.saveDistributeFailLog(assetForm, qe.qgExceptionType.code + "->" + qe.detail);
			alarmService.dingtalkAlarm("Warn", "资产入库分发出现错误", "bizChannel : " + assetForm.getBizChannel()
					+ " , bizType : " + assetForm.getBizType() + " , bizNo : " + assetForm.getBizNo()
					+ " , assetNo : " + assetForm.getAssetNo() + " , uuid : " + assetForm.getUuid()
					+ " , 错误信息 : " + qe.qgExceptionType.code + "->" + qe.detail);
		} catch (Exception ex) {
			log.error("资产入库分发出现异常, uuid : {}, bizChannel : {}, bizType : {}, bizNo : {}, assetNo : {} ", assetForm.getUuid(), 
					assetForm.getBizChannel(), assetForm.getBizType(),
					assetForm.getBizNo(), assetForm.getAssetNo(), ex);
			distributeFailLogService.saveDistributeFailLog(assetForm, "未知异常.");
			alarmService.dingtalkAlarm("Warn", "资产入库分发出现异常", "bizChannel : " + assetForm.getBizChannel()
					+ " , bizType : " + assetForm.getBizType() + " , bizNo : " + assetForm.getBizNo()
					+ " , assetNo : " + assetForm.getAssetNo() + " , uuid : " + assetForm.getUuid()
					+ " , 错误信息 : 未知错误.");
		}
	}
	
	@Override
	public boolean checkAssetForm(AssetForm assetForm) {
		// auditResult和deadLine必填
		if (StringUtils.isEmpty(assetForm.getAuditResult()) || StringUtils.isEmpty(assetForm.getDeadLine())) { return false; }
		if ("true".equals(assetForm.getAuditResult())) {
			if (StringUtils.isEmpty(assetForm.getFinanceProducts()) || StringUtils.isEmpty(assetForm.getAmount())) {
				// auditResult为true，金融产品集和amount不能为空
				return false;
			}
			BigDecimal amount = new BigDecimal(assetForm.getAmount());
			BigDecimal floor = null;
			JSONArray array = JSON.parseArray(assetForm.getFinanceProducts());
			for (int i = 0, len = array.size(); i < len; ++i) {
				JSONObject data = array.getJSONObject(i);
				BigDecimal min = new BigDecimal(data.getString("min"));
				BigDecimal max = new BigDecimal(data.getString("max"));
				BigDecimal cha = max.subtract(min);
				// 0 <= max - min <= 1
				if (!(cha.compareTo(BigDecimal.ZERO) > -1 && cha.compareTo(BigDecimal.ONE) < 1)) {
					return false;
				}
				if (floor == null || min.compareTo(floor) < 0) {
					floor = min;
				}
			}
			// amount >= floor
			if (amount.compareTo(floor) < 1) {
				return false;
			}
		}
		return true;
	}
	
	public static void main(String[] args) {
		BigDecimal min = new BigDecimal("98");
		BigDecimal max = new BigDecimal("100");
		BigDecimal cha = max.subtract(min);
		if (cha.compareTo(BigDecimal.ZERO) > -1 && cha.compareTo(BigDecimal.ONE) < 1) {
			System.out.println(true);
		} else {
			System.out.println(false);
		}
	}
}
