package com.quantgroup.asset.distribution.niwodai;

import cn.quantgroup.motan.bean.UserInfo;
import cn.quantgroup.motan.vo.UserSysResult;
import cn.quantgroup.user.IUserSdkService;
import cn.quantgroup.user.UserSdkServiceFactory;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Stopwatch;
import com.quantgroup.asset.distribution.AssetDistributionBootstrap;
import com.quantgroup.asset.distribution.model.form.AssetForm;
import com.quantgroup.asset.distribution.service.funding.IAidFundRouteRecordService;
import com.quantgroup.asset.distribution.service.jpa.entity.AidLoanFundRouteRecord;
import com.quantgroup.asset.distribution.service.niwodai.INiwodaiAssetService;
import com.quantgroup.asset.distribution.service.niwodai.INiwodaiService;
import com.quantgroup.asset.distribution.service.niwodai.vo.*;
import com.quantgroup.asset.distribution.service.redis.IRedisService;
import com.quantgroup.asset.distribution.util.GZIPUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import javax.annotation.PostConstruct;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.Map;

@RunWith(SpringRunner.class)
@SpringBootTest(classes = AssetDistributionBootstrap.class)
public class NiwodaiTest {

	@Autowired
	private INiwodaiService niwodaiService;
	@Autowired
	private INiwodaiAssetService niwodaiAssetService;
	@Autowired
	private IAidFundRouteRecordService aidFundRouteRecordService;
	@Autowired
	private IRedisService<AidLoanFundRouteRecord> redisService;
	@Autowired
	@Qualifier("httpClient")
	private CloseableHttpClient httpClient;
	@Value("${user.sdk.url}")
	private String userSysUrl;
	private IUserSdkService userSdkService;

	@PostConstruct
	private void init() {
		userSdkService = UserSdkServiceFactory.generateSDKService(userSysUrl, httpClient);
	}

	@Test
	public void testCheck() throws Exception {
		NiwodaiDataImportCheckResponseVO responseVO = niwodaiAssetService.preAudit("9f7f857c-10c3-42aa-8fc5-31c37e988b3e");
		System.out.println(JSON.toJSONString(responseVO));
	}

	@Test
	public void testUser(){
		Map<String,Object> userInfoByUuid = niwodaiAssetService.queryUserBasic2Info("ae7d04bf-1c5a-475b-98d2-b193be88cf2f","13780000000",true);
		System.out.println(JSON.toJSONString(userInfoByUuid));
	}

	@Test
	public void userBase(){
		System.out.println(JSON.toJSONString(userSdkService.findUserInfoByUuid("097aae98-5da4-428b-aa40-93530b6b5f4b")));
	}



	@Test
	public void testIncoming() {
		AssetForm assetForm = new AssetForm();
		assetForm.setUuid("ae7d04bf-1c5a-475b-98d2-b193be88cf2f");
		assetForm.setBizNo("1028791648161");
		NiwodaiIncomingResponseVO vo = niwodaiAssetService.incoming(assetForm,new HashMap<>(),1);
		System.out.println(JSON.toJSONString(vo));
	}

	@Test
	public void testRedis() {
		String bizNo = "427114368038989811";
		String fundId = "240";
		AidLoanFundRouteRecord record = aidFundRouteRecordService.findByBizNoAndFundId(bizNo, fundId);
		redisService.setEntityEx("testestst", record, 5, TimeUnit.MINUTES);

		AidLoanFundRouteRecord record1 = redisService.getEntity("testestst");
		aidFundRouteRecordService.updateAidLoanFundRouteRecordStatus(record1, 3);
		System.out.println("完成");
	}

	@Test
	public void testResult() {
//		String bizNo = "AN00000013443572551716033";
//		System.out.println(niwodaiAssetService.incomingResult(bizNo));
		System.out.println(JSON.toJSONString(userSdkService.findUserInfoByUuid("c5e485e2-8cfc-4d65-b090-47d96e4fca41").getData()));
	}

	public static void main(String[] args) throws InterruptedException {
		Stopwatch stopwatch = Stopwatch.createStarted();
		System.out.println(stopwatch.elapsed(TimeUnit.MILLISECONDS));
		TimeUnit.SECONDS.sleep(10);
		System.out.println(stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
	}
}
