package com.quantgroup.asset.distribution.niwodai;

import cn.quantgroup.user.IUserSdkService;
import cn.quantgroup.user.UserSdkServiceFactory;
import com.alibaba.fastjson.JSON;
import com.quantgroup.asset.distribution.AssetDistributionBootstrap;
import com.quantgroup.asset.distribution.model.form.AssetForm;
import com.quantgroup.asset.distribution.service.funding.IFundModuleService;
import com.quantgroup.asset.distribution.service.niwodai.INiwodaiAssetService;
import com.quantgroup.asset.distribution.service.niwodai.INiwodaiService;
import com.quantgroup.asset.distribution.service.niwodai.vo.*;
import com.quantgroup.asset.distribution.util.GZIPUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RunWith(SpringRunner.class)
@SpringBootTest(classes = AssetDistributionBootstrap.class)
public class NiwodaiTest {

	@Autowired
	private INiwodaiService niwodaiService;
	@Autowired
	private INiwodaiAssetService niwodaiAssetService;
	@Autowired
	@Qualifier("httpClient")
	private CloseableHttpClient httpClient;
	@Value("${user.sdk.url}")
	private String userSysUrl;
	private IUserSdkService userSdkService;
	@Autowired
	private IFundModuleService fundModuleService;
	@PostConstruct
	private void init() {
		userSdkService = UserSdkServiceFactory.generateSDKService(userSysUrl, httpClient);
	}

//	@Test
//	public void testCheck() throws Exception {
//		NiwodaiDataImportCheckResponseVO responseVO = niwodaiAssetService.dataCheck("9f7f857c-10c3-42aa-8fc5-31c37e988b3e");
//		System.out.println(JSON.toJSONString(responseVO));
//	}
//
//	@Test
//	public void testUser(){
//		Map<String,Object> userInfoByUuid = niwodaiAssetService.queryUserBasic2Info("ae7d04bf-1c5a-475b-98d2-b193be88cf2f","13780000000",true);
//		System.out.println(JSON.toJSONString(userInfoByUuid));
//	}
//
//	@Test
//	public void userBase(){
//		System.out.println(JSON.toJSONString(userSdkService.findUserInfoByUuid("097aae98-5da4-428b-aa40-93530b6b5f4b")));
//	}
//
//
//
	@Test
	public void testIncoming() {
		AssetForm assetForm = new AssetForm();
		assetForm.setUuid("2f0c65a8-c94e-4e03-87c6-b0ae99b100f0");
		assetForm.setBizNo("AN000000135785633731526656");

		NiwodaiIncomingResponseVO vo = niwodaiAssetService.incoming(assetForm,new HashMap<>(),1);
		System.out.println(JSON.toJSONString(vo));
	}
//
	@Test
	public void testResult(){
		NiwodaiIncomingResultResponseVO vo = niwodaiAssetService.incomingResult("AN000000135785633731526656");
		System.out.println(JSON.toJSONString(vo));
	}
//
//	@Test
//	public void testFund(){
//		fundModuleService.getAllConditionsOfFundConfig(1L);
//	}
//
//	@Test
//	public void testFundResult(){
//		List<FundConfigCondition> list = ((FundConfigSimulationVO)fundModuleService.getAllConditionsOfFundConfig(7L).getBody()).getConditionsCase();
//		fundModuleService.simulationCases(list,7L);
//	}

}
