package com.quantgroup.asset.distribution.enums.funding;

import java.util.HashSet;
import java.util.Set;

import lombok.Getter;

/**
 * 审批状态枚举
 * @author liwenbin
 *
 */
public enum AuditStatusEnum {
	
	WAIT(0, "待处理"),
	PASS(1, "审批通过"),
	REJECT(2, "审批拒绝"),
	BACK(3, "撤销");
	
	@Getter
	private int code;
	@Getter
	private String title;
	
	private static final Set<Integer> codeSet = new HashSet<>();
	
	static {
		for (AuditStatusEnum auditStatus : AuditStatusEnum.values()) {
			codeSet.add(auditStatus.getCode());
		}
	}
	AuditStatusEnum(int code, String title) {
		this.code = code;
		this.title = title;
	}
	
	public static boolean containsCode(int code) {
		if (codeSet.contains(code)) {
			return true;
		} else {
			return false;
		}
	}
}
