package com.quantgroup.asset.distribution.exception;

import com.quantgroup.asset.distribution.enums.response.MiddleOfficeCommonResponseEnum;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.WebRequest;

import com.quantgroup.asset.distribution.model.response.GlobalResponse;
/**
 * 全局异常捕获
 * 
 * @author liwenbin
 *
 */
@ControllerAdvice({ "com.quantgroup.asset.distribution" })
@Slf4j
public class GlobalControllerHandler {
	
	// 定义全局异常处理，value属性可以过滤拦截条件，此处拦截所有的Exception
	@ExceptionHandler(value = Exception.class)
	@ResponseBody
	public GlobalResponse exception(Exception ex, WebRequest request) {
		log.error("系统出现异常, ", ex);
		return new GlobalResponse(QGException.wrap(ex));
	}

	@ExceptionHandler(BindException.class)
	@ResponseBody
	public GlobalResponse handleMissingServletRequestParameter(BindException ex) {
		log.error("参数有问题, ", ex);
		return GlobalResponse.create(MiddleOfficeCommonResponseEnum.REQUEST_PARAMS_ERROR);
	}

}
