package com.quantgroup.asset.distribution.service.alarm.impl;

import com.quantgroup.asset.distribution.service.alarm.DingTalkMessage;
import lombok.Data;
import lombok.Getter;

/**
 * 钉钉链接消息
 */
@Getter
public class LinkMessage implements DingTalkMessage {
    private String msgtype = "link";
    private Link link;

    private LinkMessage() {
    }

    /**
     * 构建url消息
     *
     * @param title
     * @param text
     * @param url
     * @return
     */
    public static LinkMessage buildMessage(String title, String text, String url) {
        Link link = new Link();
        link.setText(text);
        link.setTitle(title);
        link.setMessageUrl(url);
        LinkMessage linkMessage = new LinkMessage();
        linkMessage.link = link;
        return linkMessage;
    }

    /**
     * 返回消息的Json格式字符串
     *
     * @return 消息的Json格式字符串
     */
    @Override
    public Object toJsonString() {
        return this;
    }

    /**
     * 返回@All的字符串
     *
     * @return
     */
    @Override
    public Object toJsonStringWithAlert() {
        return this;
    }

    @Data
    public static class Link {
        private String text;
        private String title;
        private String picUrl = "http://jdimage.q-gp.com/w3.png";
        private String messageUrl;
    }
}
