package com.quantgroup.asset.distribution.attribute;

import java.lang.reflect.Field;
import java.util.HashMap;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import com.quantgroup.asset.distribution.AssetDistributionBootstrap;
import com.quantgroup.asset.distribution.config.annotation.Attribute;
import com.quantgroup.asset.distribution.constant.StatusConstants;
import com.quantgroup.asset.distribution.model.entity.DistributeRecord;
import com.quantgroup.asset.distribution.model.form.AssetForm;
import com.quantgroup.asset.distribution.service.distribute.IAssetDistributeRecordService;
import com.quantgroup.asset.distribution.service.jpa.entity.Asset;
import com.quantgroup.asset.distribution.service.jpa.entity.AssetDistributeRecord;
import com.quantgroup.asset.distribution.service.jpa.repository.IAssetDistributeRecordRepository;
import com.quantgroup.asset.distribution.util.UUIDUtil;

/**
 * 资产测试
 * @author liwenbin
 *
 */
@SpringBootTest(classes = AssetDistributionBootstrap.class)
@RunWith(SpringRunner.class)
public class AssetTest {
	
	@Autowired
	private IAssetDistributeRecordService assetDistributeRecordService;
	@Autowired
	private IAssetDistributeRecordRepository repository;
	
	@Test
	public void testT() {
		AssetForm assetForm = new AssetForm();
		assetForm.setCode("0");
		assetForm.setMsg("success");
		assetForm.setUuid("561e6790-9080-41bc-8c1d-8e2524867b27");
		assetForm.setBizChannel("159843");
		assetForm.setBizNo("SP493016826165714789463533");
		assetForm.setBizType("0");
		assetForm.setAuditResult("false");
		assetForm.setDeadLine("deadLine");
		assetForm.setCallbackUrl("callbackUrl");
		assetForm.setAssetNo(UUIDUtil.getAssetNo());
		
		
		DistributeRecord record = new DistributeRecord(new HashMap<>());
		Asset asset = assetForm.transToAsset();
		AssetDistributeRecord assetDistributeRecord = assetDistributeRecordService.saveDistributeRecord(asset, record, StatusConstants.WAIT, 1);
		testUpdate(assetDistributeRecord);
	}
	
	public void testUpdate(AssetDistributeRecord assetDistributeRecord) {
		assetDistributeRecord.setEnable(false);
		assetDistributeRecordService.updateAssetDistribute(assetDistributeRecord);
	}
	
	public static void main(String[] args) throws IllegalArgumentException, IllegalAccessException {
		AssetForm assetForm = new AssetForm();
		assetForm.setCode("0");
		assetForm.setMsg("success");
		assetForm.setUuid("561e6790-9080-41bc-8c1d-8e2524867b27");
		assetForm.setBizChannel("159843");
		assetForm.setBizNo("SP493016826165714789463533");
		assetForm.setBizType("0");
		assetForm.setAuditResult("false");
		assetForm.setDeadLine("deadLine");
		assetForm.setCallbackUrl("callbackUrl");
		assetForm.setAssetNo(UUIDUtil.getAssetNo());
		
	}
	
	
	public static String checkName(String name) {
		StringBuilder sb = new StringBuilder();
		char[] chs = name.toCharArray();
		for (int i = 0, len = chs.length; i < len; ++i) {
			if (Character.isUpperCase(chs[i])) {
				sb.append("_" + Character.toLowerCase(chs[i]));
			} else {
				sb.append(chs[i]);
			}
		}
		return sb.toString();
	}
}
