package com.quantgroup.asset.distribution.service.jpa.entity;

import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.sql.Timestamp;
import java.util.Objects;

/**
 * @author shihuajun
 * @date 2021/9/2 15:02
 * @ describing
 */
@Entity
@Table(name = "channel_rule", schema = "asset-distribution", catalog = "")
@DynamicInsert
@DynamicUpdate
@Data
public class ChannelRuleEntity {
    private Long id;
    private Long fundProductId;
    private Long channelId;
    private Integer publishStatus;
    private Long fundId;
    private Long fundProId;
    private String fundName;
    private String fundType;
    private String orgType;
    private String businessType;
    private Integer creditResult;
    private String userTag;
    private String userLevel;
    private Integer priority;
    private Boolean routeWait;
    private Boolean enable;
    private Timestamp createdAt;
    private Timestamp updatedAt;

    @Id
    @GeneratedValue
    @Column(name = "id", nullable = false)
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Basic
    @Column(name = "fund_product_id", nullable = false)
    public Long getFundProductId() {
        return fundProductId;
    }

    public void setFundProductId(Long fundProductId) {
        this.fundProductId = fundProductId;
    }

    @Basic
    @Column(name = "channel_id", nullable = false)
    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    @Basic
    @Column(name = "publish_status", nullable = true)
    public Integer getPublishStatus() {
        return publishStatus;
    }

    public void setPublishStatus(Integer publishStatus) {
        this.publishStatus = publishStatus;
    }

    @Basic
    @Column(name = "fund_id", nullable = false)
    public Long getFundId() {
        return fundId;
    }

    public void setFundId(Long fundId) {
        this.fundId = fundId;
    }

    @Basic
    @Column(name = "fund_pro_id", nullable = false)
    public Long getFundProId() {
        return fundProId;
    }

    public void setFundProId(Long fundProId) {
        this.fundProId = fundProId;
    }

    @Basic
    @Column(name = "fund_name", nullable = false, length = 100)
    public String getFundName() {
        return fundName;
    }

    public void setFundName(String fundName) {
        this.fundName = fundName;
    }

    @Basic
    @Column(name = "fund_type", nullable = false, length = 20)
    public String getFundType() {
        return fundType;
    }

    public void setFundType(String fundType) {
        this.fundType = fundType;
    }

    @Basic
    @Column(name = "org_type", nullable = false, length = 20)
    public String getOrgType() {
        return orgType;
    }

    public void setOrgType(String orgType) {
        this.orgType = orgType;
    }

    @Basic
    @Column(name = "business_type", nullable = false, length = 20)
    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    @Basic
    @Column(name = "credit_result", nullable = false)
    public int getCreditResult() {
        return creditResult;
    }

    public void setCreditResult(int creditResult) {
        this.creditResult = creditResult;
    }

    @Basic
    @Column(name = "user_tag", nullable = false, length = 500)
    public String getUserTag() {
        return userTag;
    }

    public void setUserTag(String userTag) {
        this.userTag = userTag;
    }

    @Basic
    @Column(name = "user_level", nullable = false, length = 500)
    public String getUserLevel() {
        return userLevel;
    }

    public void setUserLevel(String userLevel) {
        this.userLevel = userLevel;
    }

    @Basic
    @Column(name = "priority", nullable = false)
    public int getPriority() {
        return priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Basic
    @Column(name = "route_wait", nullable = true)
    public Boolean getRouteWait() {
        return routeWait;
    }

    public void setRouteWait(Boolean routeWait) {
        this.routeWait = routeWait;
    }

    @Basic
    @Column(name = "enable", nullable = true)
    public Boolean getEnable() {
        return enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Basic
    @Column(name = "created_at", nullable = false)
    public Timestamp getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(Timestamp createdAt) {
        this.createdAt = createdAt;
    }

    @Basic
    @Column(name = "updated_at", nullable = false)
    public Timestamp getUpdatedAt() {
        return updatedAt;
    }

    public void setUpdatedAt(Timestamp updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ChannelRuleEntity that = (ChannelRuleEntity) o;
        return id.equals(that.id) && fundProductId.equals(that.fundProductId) && channelId.equals(that.channelId) && fundId
            .equals(that.fundId) && fundProId.equals(that.fundProId) && creditResult.equals(that.creditResult)
            && priority.equals(that.priority) && Objects.equals(publishStatus, that.publishStatus) && Objects.equals(fundName, that.fundName) && Objects.equals(fundType, that.fundType) && Objects.equals(orgType, that.orgType) && Objects.equals(businessType, that.businessType) && Objects.equals(userTag, that.userTag) && Objects.equals(userLevel, that.userLevel) && Objects.equals(routeWait, that.routeWait) && Objects.equals(enable, that.enable) && Objects.equals(createdAt, that.createdAt) && Objects.equals(updatedAt, that.updatedAt);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, fundProductId, channelId, publishStatus, fundId, fundProId, fundName, fundType, orgType, businessType, creditResult, userTag, userLevel, priority, routeWait, enable, createdAt, updatedAt);
    }
}
