package com.quantgroup.asset.distribution.service.funding.impl;

import com.quantgroup.asset.distribution.model.form.AssetForm;
import com.quantgroup.asset.distribution.service.funding.IAidLoanFundUserTagService;
import com.quantgroup.asset.distribution.service.jpa.entity.AidLoanFundUserTag;
import com.quantgroup.asset.distribution.service.jpa.entity.Asset;
import com.quantgroup.asset.distribution.service.jpa.repository.IAidLoanFundUserTagRepository;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.io.Serializable;

/**
 * @author : Hyuk
 * @description : AidLoanFundUserTagServiceImpl
 * @date : 2020/4/28 10:44 上午
 */
@Slf4j
@Service
public class AidLoanFundUserTagServiceImpl implements IAidLoanFundUserTagService {

    @Autowired
    private IAidLoanFundUserTagRepository aidLoanFundUserTagRepository;

    @Async
    @Override
    public void saveUserTag(AssetForm assetForm, Asset asset, String fundId, String tagText) {
        AidLoanFundUserTag aidLoanFundUserTag = new AidLoanFundUserTag();
        aidLoanFundUserTag.setAssetNo(asset.getAssetNo());
        aidLoanFundUserTag.setUuid(assetForm.getUuid());
        aidLoanFundUserTag.setBizNo(assetForm.getBizNo());
        aidLoanFundUserTag.setFundId(fundId);
        aidLoanFundUserTag.setTagText(tagText);
        aidLoanFundUserTag.setEnable(true);
        aidLoanFundUserTagRepository.save(aidLoanFundUserTag);
    }
}
