package com.quantgroup.asset.distribution.service.jpa.repository;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import com.quantgroup.asset.distribution.service.jpa.entity.AssetDistributeRecord;

/**
 * 资产分发记录Repository
 * @author liwenbin
 *
 */
public interface IAssetDistributeRecordRepository extends JpaRepository<AssetDistributeRecord, Long>{
	
	public List<AssetDistributeRecord> findByAssetNo(String assetNo);
	
	@Query(value = "select * from asset_distribute_record where biz_no = ?1 order by created_at desc limit 1", nativeQuery = true)
	public AssetDistributeRecord findByBizNoOrderByCreatedAtDescLimitOne(String bizNo);
}
