package com.quantgroup.asset.distribution.service.funding.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import com.quantgroup.asset.distribution.service.funding.IFundModuleLimitTypeService;
import com.quantgroup.asset.distribution.service.jpa.entity.FundModuleLimitTypeConfig;
import com.quantgroup.asset.distribution.service.jpa.repository.IFundModuleLimitTypeConfigRepository;

@Service
public class FundModuleLimitTypeServiceImpl implements IFundModuleLimitTypeService{
	
	@Autowired
	private IFundModuleLimitTypeConfigRepository fundModuleLimitTypeConfigRepository;

	@Cacheable(value="cacheManager", key="'ASSET_DISTRIBUTION:FUND_MODULE:ALL_LIMIT_TYPE:CC8C'")
	@Override
	public List<FundModuleLimitTypeConfig> getAllLimitType() {
		List<FundModuleLimitTypeConfig> configList = fundModuleLimitTypeConfigRepository.findByEnableIsTrue();
		return configList;
	}

	@CacheEvict(value="cacheManager", key="'ASSET_DISTRIBUTION:FUND_MODULE:ALL_LIMIT_TYPE:CC8C'")
	@Override
	public void clearCache() {
	}
}
