package com.quantgroup.asset.distribution.service.jpa.entity;

import javax.persistence.*;
import java.sql.Timestamp;
import java.util.Objects;

/**
 * @author shihuajun
 * @date 2021/8/26 17:57
 * @ describing
 */
@Entity
@Table(name = "routing_record", schema = "asset-distribution")
public class RoutingRecordEntity {
    private long id;
    private String phone;
    private String uuid;
    private String creditNo;
    private Byte status;
    private String routedResult;
    private Timestamp routedAt;
    private Timestamp createdAt;
    private Timestamp updatedAt;

    @Id
    @Column(name = "id", nullable = false)
    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Basic
    @Column(name = "phone", nullable = false, length = 20)
    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    @Basic
    @Column(name = "uuid", nullable = false, length = 50)
    public String getUuid() {
        return uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Basic
    @Column(name = "credit_no", nullable = false, length = 50)
    public String getCreditNo() {
        return creditNo;
    }

    public void setCreditNo(String creditNo) {
        this.creditNo = creditNo;
    }

    @Basic
    @Column(name = "status", nullable = true)
    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    @Basic
    @Column(name = "routed_result", nullable = false, length = 2000)
    public String getRoutedResult() {
        return routedResult;
    }

    public void setRoutedResult(String routedResult) {
        this.routedResult = routedResult;
    }

    @Basic
    @Column(name = "routed_at", nullable = false)
    public Timestamp getRoutedAt() {
        return routedAt;
    }

    public void setRoutedAt(Timestamp routedAt) {
        this.routedAt = routedAt;
    }

    @Basic
    @Column(name = "created_at", nullable = false)
    public Timestamp getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(Timestamp createdAt) {
        this.createdAt = createdAt;
    }

    @Basic
    @Column(name = "updated_at", nullable = false)
    public Timestamp getUpdatedAt() {
        return updatedAt;
    }

    public void setUpdatedAt(Timestamp updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RoutingRecordEntity that = (RoutingRecordEntity) o;
        return id == that.id && Objects.equals(phone, that.phone) && Objects.equals(uuid, that.uuid) && Objects.equals(creditNo, that.creditNo) && Objects.equals(status, that.status) && Objects.equals(routedResult, that.routedResult) && Objects.equals(routedAt, that.routedAt) && Objects.equals(createdAt, that.createdAt) && Objects.equals(updatedAt, that.updatedAt);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, phone, uuid, creditNo, status, routedResult, routedAt, createdAt, updatedAt);
    }

    @PrePersist
    public void prePersist() {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        createdAt = timestamp;
        updatedAt = timestamp;
        routedAt = timestamp;
    }

    @PreUpdate
    public void preUpdate() {
        updatedAt = new Timestamp(System.currentTimeMillis());
    }
}
