package com.quantgroup.asset.distribution.service.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.quantgroup.asset.distribution.exception.QGExceptionType;
import com.quantgroup.asset.distribution.exception.QGPreconditions;
import com.quantgroup.asset.distribution.model.form.AssetForm;
import com.quantgroup.asset.distribution.service.IAssetAttributeService;
import com.quantgroup.asset.distribution.service.httpclient.IHttpService;
import com.quantgroup.asset.distribution.service.jpa.entity.AssetAttributeExtendConfig;

import lombok.extern.slf4j.Slf4j;

/**
 * 资产扩展属性Service
 * 
 * @author liwenbin
 *
 */
@Slf4j
@Service
public class AssetAttributeServiceImpl implements IAssetAttributeService {
	
	@Autowired
	private IHttpService httpService;
	
	@Value("${rule.engine.url}")
	private String ruleEngineURL;

	/**
	 * 获取所有资产扩展属性value
	 */
	@Override
	public Map<String, Object> getAllAssetAttributeValue(List<AssetAttributeExtendConfig> assetAttributeExtendConfigList, AssetForm assetForm) {
		Map<String, Object> data = new HashMap<>();
		// 决策特征Set
		Set<String> decKeys = new HashSet<>();
		// 默认增加一个用户类型
		decKeys.add("user_loan_type_latest");
		if (assetAttributeExtendConfigList != null && assetAttributeExtendConfigList.size() > 0) {
			for (AssetAttributeExtendConfig config : assetAttributeExtendConfigList) {
				if (config.getAssetAttributeType() == 1) {
					// 模型分
					decKeys.add(config.getAssetAttributeCode());
				}
			}
		}

		// 去请求决策特征
		Map<String, Object> decAttributeValue = getDecAttributeValue(decKeys, assetForm);
		data.putAll(decAttributeValue);
		return data;
	}
	
	/**
	 * 获取所有决策特征属性值
	 * @param decKeys
	 * @return
	 */
	public Map<String, Object> getDecAttributeValue(Set<String> decKeys, AssetForm assetForm) {
		if (CollectionUtils.isEmpty(decKeys)) { return MapUtils.EMPTY_MAP; }
		String result = httpService.post(ruleEngineURL + "/feature/get", new HashMap<String, String>(){{
			put("uuid", assetForm.getUuid());
			put("bizChannel", assetForm.getBizChannel());
			put("bizNo", assetForm.getBizNo());
			put("bizType", assetForm.getBizType());
			put("keys", StringUtils.join(decKeys, ","));
		}});
		JSONObject resultJSON = null;
		QGPreconditions.checkArgument(StringUtils.isNotEmpty(result) && (resultJSON = JSON.parseObject(result)).getInteger("code") == 0, QGExceptionType.GET_DEC_ATTRIBUTE_VALUE_ERROR, assetForm.getUuid(), JSON.toJSONString(decKeys));
		Map<String, Object > data = resultJSON.getJSONObject("body");
		log.info("决策特征属性获取完成, uuid : {}, bizChannel : {}, bizNo : {}, bizType : {}, data : {}", assetForm.getUuid(), assetForm.getBizChannel(), assetForm.getBizNo(), assetForm.getBizType(), JSON.toJSONString(data));
		return data;
	}
}
