package com.quantgroup.asset.distribution.service.newrule.pojo.enums;

import lombok.Getter;

/**
 * @author shihuajun
 * @date 2021/9/2 17:01
 * @ describing
 */
@Getter
public enum AreaEnum {

    NO_DEMAND(0,"无地区限制"),
    CHOOSE_ONE_MORE(1,"地区限制多选一"),
    TWO_OUT_OF_MANY(2,"地区限制多选二"),
    ALL_DEMAND(3,"地区限制全选");

    private final Integer code;
    private final String desc;

    AreaEnum(Integer code,String desc){
        this.code = code;
        this.desc = desc;
    }

    public static AreaEnum parse(int code){
        for (AreaEnum ae : AreaEnum.values()) {
            if (code == ae.getCode()){
                return ae;
            }
        }
        throw new RuntimeException("解析AreaEnum出问题了，没有对应的枚举类型");
    }
}
