package com.quantgroup.asset.distribution;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ctrip.framework.apollo.spring.annotation.EnableApolloConfig;
import com.ctrip.framework.apollo.spring.config.ApolloPropertySourceInitializer;

import lombok.extern.slf4j.Slf4j;

@EnableJpaRepositories(basePackages = {"com.quantgroup.asset.distribution.service.jpa.repository"})
@EntityScan(basePackages = {"com.quantgroup.asset.distribution.service.jpa.entity"})
@EnableTransactionManagement
@EnableConfigurationProperties
@EnableCaching
@EnableScheduling
@EnableAsync
@EnableAspectJAutoProxy
@Slf4j
@SpringBootApplication
@EnableApolloConfig
public class AssetDistributionBootstrap {
	
	public static void main(String[] args) {
        JSON.DEFAULT_GENERATE_FEATURE |= SerializerFeature.WriteEnumUsingToString.getMask();
        SpringApplication springApplication = new SpringApplication(AssetDistributionBootstrap.class);
        springApplication.addInitializers(new ApolloPropertySourceInitializer());
        springApplication.run(args);
        log.info("资产--分发系统服务启动完成....");
    }
}
