package com.quantgroup.asset.distribution.enums;

import com.quantgroup.asset.distribution.exception.QGException;
import com.quantgroup.asset.distribution.exception.QGExceptionType;
import com.quantgroup.asset.distribution.exception.QGPreconditions;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

@Slf4j
public enum UnionType {
  And("and", "而且"), Or("or", "或者");
  private String code;
  private String description;

  UnionType(String code, String description) {
    this.code = code;
    this.description = description;
  }

  public static UnionType fromCode(String code) {
    QGPreconditions.checkArgument(StringUtils.isNoneBlank(code), QGExceptionType.COMMON_STRING_PARAM_IS_ALL_NULL, "条件组类型");
    for (UnionType unionType : UnionType.values()) {
      if (StringUtils.equalsAnyIgnoreCase(code, unionType.code)) {
        return unionType;
      }
    }
    log.error("枚举不存在, code = {}", code);
    throw new QGException(QGExceptionType.COMMON_ILLEGAL_PARAM);
  }
}
