package com.quantgroup.asset.distribution.service.jpa.repository;

import com.quantgroup.asset.distribution.service.jpa.entity.FundModuleChannelFundConfig;
import com.quantgroup.asset.distribution.service.jpa.entity.FundModuleChannelFundConfigNew;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;

import java.math.BigInteger;
import java.util.List;

/**
 * @author : Hyuk
 * @description : IFundModuleChannelFundConfigNewRepository
 * @date : 2020/2/26 5:53 下午
 */
public interface IFundModuleChannelFundConfigNewRepository extends JpaRepository<FundModuleChannelFundConfigNew, Long>, JpaSpecificationExecutor<FundModuleChannelFundConfigNew> {

    /**
     * 根据渠道号查询渠道资方配置
     * @param bizChannel
     * @return
     */
    public List<FundModuleChannelFundConfigNew> findByBizChannelAndEnableIsTrue(String bizChannel);

    /**
     * 根据配置id查询资方配置
     * @param id
     * @return
     */
    public FundModuleChannelFundConfigNew findByIdAndEnableIsTrue(Long id);

    /**
     * 根据id查询资方配置, 主要是审核部分用, 这时候配置还没应用到线上, enable还是false
     * @param id
     * @return
     */
    public FundModuleChannelFundConfigNew findById(Long id);

    @Query(value = "select biz_channel from fund_module_channel_fund_config_new where enable = 1", nativeQuery = true)
    public List<String> getAllBizChannel();

    @Query(value = "SELECT count(*) FROM fund_module_channel_fund_config_new where  id in ?3 and fund_ids LIKE %?1% and biz_channel = ?2", nativeQuery = true)
    Long count(Long fundId,String bizChannel,List<BigInteger> ids);

    @Query(value = "SELECT count(*) FROM fund_module_channel_fund_config_new where id in ?2 and fund_ids LIKE %?1%", nativeQuery = true)
    Long count(Long fundId,List<BigInteger> ids);

}
