package com.quantgroup.asset.distribution.service.jpa.entity;

import java.io.Serializable;
import java.sql.Timestamp;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;

import lombok.Data;

/**
 * 分发失败日志表
 * @author liwenbin
 *
 */
@Table(name = "distribute_fail_log")
@Entity
@Data
public class DistributeFailLog implements Serializable{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id;
	
	@Column(name = "biz_channel")
	private String bizChannel;
	
	@Column(name = "asset_no")
	private String assetNo;
	
	@Column(name = "biz_no")
	private String bizNo;
	
	@Column(name = "biz_type")
	private Integer bizType;
	
	@Column(name = "uuid")
	private String uuid;
	
	@Column(name = "context")
	private String context;
	
	@Column(name = "fail_reason")
	private String failReason;
	
	@Column(name = "enable")
	private Boolean enable;

    @Column(name = "call_type")
    private Integer callType = 0;

	@Column(name = "created_at")
	private Timestamp createdAt;
	
	@Column(name = "updated_at")
	private Timestamp updatedAt;
	
	@PrePersist
    public void prePersist() {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        createdAt = timestamp;
        updatedAt = timestamp;
    }

    @PreUpdate
    public void preUpdate() {
        updatedAt = new Timestamp(System.currentTimeMillis());
    }
	
}
