package com.quantgroup.asset.distribution.model.entity.route.fundproduct;

import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;
import java.util.Map;

@Data
public class FundProductSaveVo {
    @NotNull(message = "id不能为空")
    private Long id;
    @NotNull(message = "资金编号不能为空")
    private Long fundId;
    @NotNull(message = "资金产品编号不能为空")
    private Long fundProId;
    @NotBlank(message = "资金名称不能为空")
    private String fundName;
    @NotBlank(message = "资金类型不能为空")
    private String fundType;
    @NotBlank(message = "机构类型不能为空")
    private String orgType;
    @NotBlank(message = "业务类型不能为空")
    private String businessType;
    @NotBlank(message = "业务系统不能为空")
    private String systermType;
    /**
     * 基本信息和其他信息字段,对应的value
     */
    @NotEmpty(message = "规则集不能为空")
    private Map<Long,String> ruleValueMap;
}
