package com.quantgroup.asset.distribution.service.jpa.repository;

import java.sql.Timestamp;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;

import com.quantgroup.asset.distribution.service.jpa.entity.DistributeFailLog;

/**
 * 分发失败Repository
 * @author liwenbin
 *
 */
public interface IDistributeFailLogRepository extends JpaRepository<DistributeFailLog, Long>{
	
	/**
	 * 根据时间查询失败订单
	 * @param start
	 * @param end
	 * @param enable
     * @param callType
	 * @param pageable
	 * @return
	 */
	public Page<DistributeFailLog> findByCreatedAtBetweenAndEnableAndCallType(Timestamp start, Timestamp end, Boolean enable,Integer callType ,Pageable pageable);
}
