package com.quantgroup.asset.distribution.controller;

import com.alibaba.fastjson.JSONObject;
import com.quantgroup.asset.distribution.enums.response.AssetResponse;
import com.quantgroup.asset.distribution.enums.response.MiddleOfficeCommonResponseEnum;
import com.quantgroup.asset.distribution.model.response.GlobalResponse;
import com.quantgroup.asset.distribution.service.newrule.CoreFilter;
import com.quantgroup.asset.distribution.service.newrule.pojo.funds.FundCallBackParam;
import com.quantgroup.asset.distribution.service.newrule.third.AuditResponce;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.Valid;

/**
 * @author shihuajun
 * @date 2021/9/1 15:09
 * @ describing
 */
@Slf4j
@RestController
@RequestMapping("/biz")
public class NewAssertController {
    @Resource
    private CoreFilter coreFilter;

    @RequestMapping("/core/asset_handler")
    public GlobalResponse assetsHandler(AuditResponce auditResponce) {
        log.info("风控通知审核结果：{}", JSONObject.toJSONString(auditResponce));
        try {
            coreFilter.coreHandle(auditResponce);
        } catch (Exception e) {
            log.error("风控通知审核结果处理异常, e:{}", ExceptionUtils.getStackTrace(e));
            return GlobalResponse.error(e.getMessage());
        }
        return GlobalResponse.create(AssetResponse.SUCCESS);
    }

    /**
     * 之后需要加入竞价的逻辑
     * http://open.quantgroups.com/project/181/interface/api/4536
     * @param param
     * @return
     */
    @RequestMapping(value = "/core/select_fund" ,method = {RequestMethod.POST})
    public GlobalResponse selectFund(@RequestBody FundCallBackParam param) {
        if (CollectionUtils.isEmpty(param.getResult())){
            return GlobalResponse.create(MiddleOfficeCommonResponseEnum.REQUEST_PARAMS_ERROR);
        }
        return GlobalResponse.create(AssetResponse.SUCCESS,param.getResult().get(0).getFundId());
    }
}
