package com.quantgroup.asset.distribution.controller;

import com.quantgroup.asset.distribution.constant.RedisKeyConstants;
import com.quantgroup.asset.distribution.model.response.GlobalResponse;
import com.quantgroup.asset.distribution.service.asset.IAssetAttributeExtendConfigService;
import com.quantgroup.asset.distribution.service.authority.IAuthorityService;
import com.quantgroup.asset.distribution.service.distribute.IAssetDistributeRuleConfigService;
import com.quantgroup.asset.distribution.service.funding.IAidLoanFundConfigService;
import com.quantgroup.asset.distribution.service.funding.IFundModuleLimitTypeService;
import com.quantgroup.asset.distribution.service.redis.IRedisService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * Created by renfeng on 2019/7/22.
 */

@Slf4j
@RestController
@RequestMapping("/ex")
public class RedisFlushController {



    private final static String authKey="3ruhhdf9924hrodnfjkasdhf8209";


    @Autowired
    private IRedisService<String> redisService;
    @Autowired
    private IAssetAttributeExtendConfigService assetAttributeExtendConfigService;
    @Autowired
    private IAuthorityService authorityService;
    @Autowired
    private IAssetDistributeRuleConfigService assetDistributeRuleConfigService;
    @Autowired
    private IFundModuleLimitTypeService limitTypeService;
    @Autowired
    private IAidLoanFundConfigService aidLoanFundConfigService;

    /**
     * 助贷资金池刷新
     * @param key
     * @return
     */
    @RequestMapping("/aid_loan_fund_pool_flush")
    public GlobalResponse aidLoanFundPoolFlush(String key){
        if(authKey.equals(key))
            redisService.del(RedisKeyConstants.AID_LOAN_POOLKEYS_HMSET_KEY);
        return GlobalResponse.success();
    }

    @RequestMapping("/attribute_extend_config_flush")
    public GlobalResponse attributeExtendConfigFlush(String key) {
    	if(authKey.equals(key)) { assetAttributeExtendConfigService.clearAllExtendConfigCache(); }
    	return GlobalResponse.success();
    }
    
    @RequestMapping("/authority_flush")
    public GlobalResponse authorityFlush(String key, String authKey, String authPass) {
    	if(this.authKey.equals(key)) { authorityService.clearCacheByAuthKeyAndAuthPass(authKey, authPass); }
    	return GlobalResponse.success();
    }

    @RequestMapping("/distribute_rule_config_flush")
    public GlobalResponse distributeRuleConfigFlush(String key) {
    	if(authKey.equals(key)) { assetDistributeRuleConfigService.clearRuleConfigCache(); }
    	return GlobalResponse.success();
    }
    
    @RequestMapping("/limit_type_flush")
    public GlobalResponse limitTypeFlush(String key) {
    	if(authKey.equals(key)) { limitTypeService.clearCache(); }
    	return GlobalResponse.success();
    }

    @RequestMapping("/aid_loan_pool_flush")
    public GlobalResponse AidLoanPoolFlush(String key) {
        if(authKey.equals(key)) {
            aidLoanFundConfigService.clearCache();
            return GlobalResponse.success();
        }
        return GlobalResponse.error("authKey验证失败");
    }
}
